/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.streaming.amqp;

import io.radanalytics.streaming.amqp.AMQPFlowController;
import io.radanalytics.streaming.amqp.AMQPFlowControllerListener;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\r-\u0011q#Q'R!\u0006\u001b\u0018P\\2GY><8i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011\u0001B1ncBT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u00031\u0011\u0018\rZ1oC2LH/[2t\u0015\u0005I\u0011AA5p\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0003\u0013\ty!A\u0001\nB\u001bF\u0003f\t\\8x\u0007>tGO]8mY\u0016\u0014\bcA\t\u001715\t!C\u0003\u0002\u0014)\u0005!1m\u001c:f\u0015\t)\u0002\"A\u0003wKJ$\b0\u0003\u0002\u0018%\t9\u0001*\u00198eY\u0016\u0014\bCA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011a\u0017M\\4\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u0005\u0019>tw\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003!\u0011XmY3jm\u0016\u0014\bCA\u0012'\u001b\u0005!#BA\u0013\u0015\u0003\u0019\u0001(o\u001c;p]&\u0011q\u0005\n\u0002\u000f!J|Go\u001c8SK\u000e,\u0017N^3s\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00037jgR,g.\u001a:\u0011\u00055Y\u0013B\u0001\u0017\u0003\u0005i\tU*\u0015)GY><8i\u001c8ue>dG.\u001a:MSN$XM\\3s\u0011!q\u0003A!A!\u0002\u0013A\u0012aB7bqJ\u000bG/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005aA\u0011\u0011#M\u0005\u0003eI\u0011QAV3sibDQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtD#\u0002\u001c8qeR\u0004CA\u0007\u0001\u0011\u0015\t3\u00071\u0001#\u0011\u0015I3\u00071\u0001+\u0011\u0015q3\u00071\u0001\u0019\u0011\u0015)2\u00071\u00011\u0011\u001da\u0004\u00011A\u0005\u0002u\nQ!];fk\u0016,\u0012A\u0010\t\u0004\u007f\u0019CU\"\u0001!\u000b\u0005\u0005\u0013\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0007\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005)\u0015!B:dC2\f\u0017BA$A\u0005\u0015\tV/Z;f!\u0011I%\nT(\u000e\u0003\u0011K!a\u0013#\u0003\rQ+\b\u000f\\33!\t\u0019S*\u0003\u0002OI\tq\u0001K]8u_:$U\r\\5wKJL\bC\u0001)[\u001b\u0005\t&B\u0001*T\u0003\u001diWm]:bO\u0016T!!\n+\u000b\u0005U3\u0016\u0001B9qS\u0012T!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111,\u0015\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u001di\u0006\u00011A\u0005\u0002y\u000b\u0011\"];fk\u0016|F%Z9\u0015\u0005}\u0013\u0007CA%a\u0013\t\tGI\u0001\u0003V]&$\bbB2]\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0004BB3\u0001A\u0003&a(\u0001\u0004rk\u0016,X\r\t\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0003\u0011a\u0017m\u001d;\u0016\u0003aAqA\u001b\u0001A\u0002\u0013\u00051.\u0001\u0005mCN$x\fJ3r)\tyF\u000eC\u0004dS\u0006\u0005\t\u0019\u0001\r\t\r9\u0004\u0001\u0015)\u0003\u0019\u0003\u0015a\u0017m\u001d;!\u0011\u001d\u0001\bA1A\u0005\u0002E\f\u0001\u0003]3s[&$8\u000fU3s'\u0016\u001cwN\u001c3\u0016\u0003I\u0004\"!S:\n\u0005Q$%A\u0002#pk\ndW\r\u0003\u0004w\u0001\u0001\u0006IA]\u0001\u0012a\u0016\u0014X.\u001b;t!\u0016\u00148+Z2p]\u0012\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!]\u0001\u0015gR\f'\r\\3J]R,'O^1m\u001b&\u001c'o\\:\t\ri\u0004\u0001\u0015!\u0003s\u0003U\u0019H/\u00192mK&sG/\u001a:wC2l\u0015n\u0019:pg\u0002Bq\u0001 \u0001A\u0002\u0013\u0005Q0\u0001\buS6,'oU2iK\u0012,H.\u001a3\u0016\u0003y\u0004\"!S@\n\u0007\u0005\u0005AIA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0011A\u0005;j[\u0016\u00148k\u00195fIVdW\rZ0%KF$2aXA\u0005\u0011!\u0019\u00171AA\u0001\u0002\u0004q\bbBA\u0007\u0001\u0001\u0006KA`\u0001\u0010i&lWM]*dQ\u0016$W\u000f\\3eA!Q\u0011\u0011\u0003\u0001\t\u0006\u0004%I!a\u0005\u0002\u00071|w-\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001ca\u000bQa\u001d7gi)LA!a\b\u0002\u001a\t1Aj\\4hKJD!\"a\t\u0001\u0011\u0003\u0005\u000b\u0015BA\u000b\u0003\u0011awn\u001a\u0011)\t\u0005\u0005\u0012q\u0005\t\u0004\u0013\u0006%\u0012bAA\u0016\t\nIAO]1og&,g\u000e\u001e\u0005\b\u0003_\u0001A\u0011IA\u0019\u0003)\u0011WMZ8sK>\u0003XM\u001c\u000b\u0002?\"9\u0011Q\u0007\u0001\u0005B\u0005E\u0012a\u00032fM>\u0014Xm\u00117pg\u0016Dq!!\u000f\u0001\t\u0003\nY$A\u0004bGF,\u0018N]3\u0015\u000b}\u000bi$!\u0011\t\u000f\u0005}\u0012q\u0007a\u0001\u0019\u0006AA-\u001a7jm\u0016\u0014\u0018\u0010\u0003\u0004S\u0003o\u0001\ra\u0014\u0005\b\u0003\u000b\u0002A\u0011BA\u0019\u00035\u00198\r[3ek2,G+[7fe\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013A\u00025b]\u0012dW\rF\u0002`\u0003\u001bBq!a\u0014\u0002H\u0001\u0007\u0001$A\u0004uS6,'/\u00133")
public final class AMQPAsyncFlowController
extends AMQPFlowController
implements Handler<Long> {
    private final Vertx vertx;
    private Queue<Tuple2<ProtonDelivery, Message>> queue;
    private Long last;
    private final double permitsPerSecond;
    private final double stableIntervalMicros;
    private boolean timerScheduled;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        AMQPAsyncFlowController aMQPAsyncFlowController = this;
        synchronized (aMQPAsyncFlowController) {
            if (!this.bitmap$trans$0) {
                this.log = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    public Queue<Tuple2<ProtonDelivery, Message>> queue() {
        return this.queue;
    }

    public void queue_$eq(Queue<Tuple2<ProtonDelivery, Message>> x$1) {
        this.queue = x$1;
    }

    public Long last() {
        return this.last;
    }

    public void last_$eq(Long x$1) {
        this.last = x$1;
    }

    public double permitsPerSecond() {
        return this.permitsPerSecond;
    }

    public double stableIntervalMicros() {
        return this.stableIntervalMicros;
    }

    public boolean timerScheduled() {
        return this.timerScheduled;
    }

    public void timerScheduled_$eq(boolean x$1) {
        this.timerScheduled = x$1;
    }

    private Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public void beforeOpen() {
        this.last_$eq(Predef$.MODULE$.long2Long(0L));
        this.timerScheduled_$eq(false);
        this.queue().clear();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permitsPerSecond ", ", stableIntervalMicros ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.permitsPerSecond()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toMillis((long)this.stableIntervalMicros()))})));
    }

    @Override
    public void beforeClose() {
    }

    @Override
    public void acquire(ProtonDelivery delivery, Message message) {
        Long now = Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime()));
        if ((double)Predef$.MODULE$.Long2long(now) > (double)Predef$.MODULE$.Long2long(this.last()) + this.stableIntervalMicros() && this.queue().isEmpty()) {
            this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
            super.acquire(delivery, message);
        } else {
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--> Enqueue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(delivery.getTag())})));
            this.queue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)delivery, (Object)message)}));
            this.scheduleTimer();
        }
    }

    private void scheduleTimer() {
        if (!this.timerScheduled()) {
            Long delay = Predef$.MODULE$.long2Long(TimeUnit.MICROSECONDS.toMillis((long)this.stableIntervalMicros()));
            if (BoxesRunTime.equalsNumObject((Number)delay, (Object)BoxesRunTime.boxToInteger((int)0))) {
                delay = Predef$.MODULE$.long2Long(1L);
            }
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer scheduled every ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{delay})));
            this.vertx.setTimer(Predef$.MODULE$.Long2long(delay), this);
            this.timerScheduled_$eq(true);
        }
    }

    @Override
    public void handle(Long timerId) {
        this.timerScheduled_$eq(false);
        Tuple2 t = (Tuple2)this.queue().dequeue();
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<-- Dequeue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(((ProtonDelivery)t._1()).getTag())})));
        this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
        super.acquire((ProtonDelivery)t._1(), (Message)t._2());
        if (!this.queue().isEmpty()) {
            this.scheduleTimer();
        }
    }

    public AMQPAsyncFlowController(ProtonReceiver receiver, AMQPFlowControllerListener listener, Long maxRate, Vertx vertx) {
        this.vertx = vertx;
        super(receiver, listener);
        this.queue = new Queue();
        this.last = Predef$.MODULE$.long2Long(0L);
        this.permitsPerSecond = Predef$.MODULE$.Long2long(maxRate);
        this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / this.permitsPerSecond();
        this.timerScheduled = false;
    }
}

