/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.net.NetSocket;
import java.util.ArrayList;
import java.util.List;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestImpl request;
    private final ClientConnection conn;
    private final HttpResponse response;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private LastHttpContent trailer;
    private boolean paused;
    private Buffer pausedChunk;
    private boolean hasPausedEnd;
    private LastHttpContent pausedTrailer;
    private NetSocket netSocket;
    private long bytesRead;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(HttpClientRequestImpl request, ClientConnection conn, HttpResponse response) {
        this.statusCode = response.getStatus().code();
        this.statusMessage = response.getStatus().reasonPhrase();
        this.request = request;
        this.conn = conn;
        this.response = response;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.headers == null) {
                this.headers = new HeadersAdaptor(this.response.headers());
            }
            return this.headers;
        }
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.trailers == null) {
                this.trailers = new HeadersAdaptor(new DefaultHttpHeaders());
            }
            return this.trailers;
        }
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers.get(trailerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> cookies() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
                this.cookies.addAll(this.response.headers().getAll(HttpHeaders.SET_COOKIE));
                if (this.trailer != null) {
                    this.cookies.addAll(this.trailer.trailingHeaders().getAll(HttpHeaders.SET_COOKIE));
                }
            }
            return this.cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse handler(Handler<Buffer> dataHandler) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            this.dataHandler = dataHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            this.endHandler = endHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> exceptionHandler) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse pause() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (!this.paused) {
                this.paused = true;
                this.conn.doPause();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse resume() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.paused) {
                this.paused = false;
                this.doResume();
                this.conn.doResume();
            }
            return this;
        }
    }

    @Override
    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
        BodyHandler handler = new BodyHandler();
        this.handler((Handler)handler);
        this.endHandler(v -> handler.notifyHandler(bodyHandler));
        return this;
    }

    private void doResume() {
        if (this.hasPausedEnd) {
            if (this.pausedChunk != null) {
                Buffer theChunk = this.pausedChunk;
                this.conn.getContext().runOnContext(v -> this.handleChunk(theChunk));
                this.pausedChunk = null;
            }
            LastHttpContent theTrailer = this.pausedTrailer;
            this.conn.getContext().runOnContext(v -> this.handleEnd(theTrailer));
            this.hasPausedEnd = false;
            this.pausedTrailer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChunk(Buffer data) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.paused) {
                if (this.pausedChunk == null) {
                    this.pausedChunk = data.copy();
                } else {
                    this.pausedChunk.appendBuffer(data);
                }
            } else {
                this.request.dataReceived();
                if (this.pausedChunk != null) {
                    data = this.pausedChunk.appendBuffer(data);
                    this.pausedChunk = null;
                }
                this.bytesRead += (long)data.length();
                if (this.dataHandler != null) {
                    try {
                        this.dataHandler.handle(data);
                    }
                    catch (Throwable t) {
                        this.handleException(t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd(LastHttpContent trailer) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            this.conn.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
            this.request.reportResponseEnd(this);
            if (this.paused) {
                this.hasPausedEnd = true;
                this.pausedTrailer = trailer;
            } else {
                this.trailer = trailer;
                this.trailers = new HeadersAdaptor(trailer.trailingHeaders());
                if (this.endHandler != null) {
                    try {
                        this.endHandler.handle(null);
                    }
                    catch (Throwable t) {
                        this.handleException(t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        ClientConnection clientConnection = this.conn;
        synchronized (clientConnection) {
            if (this.netSocket == null) {
                this.netSocket = this.conn.createNetSocket();
            }
            return this.netSocket;
        }
    }

    private static final class BodyHandler
    implements Handler<Buffer> {
        private Buffer body;

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body().appendBuffer(event);
        }

        private Buffer body() {
            if (this.body == null) {
                this.body = Buffer.buffer();
            }
            return this.body;
        }

        void notifyHandler(Handler<Buffer> bodyHandler) {
            bodyHandler.handle(this.body());
            this.body = null;
        }
    }
}

