/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.proton.ProtonDelivery;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;

public interface ProtonHelper {
    public static Message message() {
        return Proton.message();
    }

    public static Message message(String body) {
        Message value = ProtonHelper.message();
        value.setBody(new AmqpValue(body));
        return value;
    }

    public static Message message(String address, String body) {
        Message value = ProtonHelper.message(body);
        value.setAddress(address);
        return value;
    }

    public static ErrorCondition condition(String condition, String description) {
        return new ErrorCondition(Symbol.valueOf(condition), description);
    }

    public static byte[] tag(String tag) {
        return tag.getBytes(StandardCharsets.UTF_8);
    }

    public static ProtonDelivery accepted(ProtonDelivery delivery, boolean settle) {
        delivery.disposition(Accepted.getInstance(), settle);
        return delivery;
    }

    public static ProtonDelivery rejected(ProtonDelivery delivery, boolean settle) {
        delivery.disposition(new Rejected(), settle);
        return delivery;
    }

    public static ProtonDelivery released(ProtonDelivery delivery, boolean settle) {
        delivery.disposition(Released.getInstance(), settle);
        return delivery;
    }

    public static ProtonDelivery modified(ProtonDelivery delivery, boolean settle, boolean deliveryFailed, boolean undeliverableHere) {
        Modified modified = new Modified();
        modified.setDeliveryFailed(deliveryFailed);
        modified.setUndeliverableHere(undeliverableHere);
        delivery.disposition(modified, settle);
        return delivery;
    }

    public static <T> AsyncResult<T> future(T value, ErrorCondition err) {
        if (err.getCondition() != null) {
            return Future.failedFuture(err.toString());
        }
        return Future.succeededFuture(value);
    }
}

