/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.streaming.amqp;

import io.radanalytics.streaming.amqp.AMQPFlowController;
import io.radanalytics.streaming.amqp.AMQPFlowControllerListener;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\r-\u0011\u0011$Q'R!\"\u0013\u0018i]=oG\u001acwn^\"p]R\u0014x\u000e\u001c7fe*\u00111\u0001B\u0001\u0005C6\f\bO\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tAB]1eC:\fG.\u001f;jGNT\u0011!C\u0001\u0003S>\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003%\u0005k\u0015\u000b\u0015$m_^\u001cuN\u001c;s_2dWM\u001d\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005!\u0011VO\u001c8bE2,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0011I,7-Z5wKJ\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\rA\u0014x\u000e^8o\u0015\ty\u0002\"A\u0003wKJ$\b0\u0003\u0002\"9\tq\u0001K]8u_:\u0014VmY3jm\u0016\u0014\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u00111L7\u000f^3oKJ\u0004\"!D\u0013\n\u0005\u0019\u0012!AG!N#B3En\\<D_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u0014\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u000f5\f\u0007PU1uKB\u0011\u0011CK\u0005\u0003WI\u0011A\u0001T8oO\")Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"Ba\f\u00192eA\u0011Q\u0002\u0001\u0005\u000631\u0002\rA\u0007\u0005\u0006G1\u0002\r\u0001\n\u0005\u0006Q1\u0002\r!\u000b\u0005\bi\u0001\u0011\r\u0011\"\u00046\u0003]i\u0015N\\*uC\ndW-\u00138uKJ4\u0018\r\\'jGJ|7/F\u00017\u001f\u00059\u0004\u0005\u0003!Z\u0001\u0001\u0001\u0001\u0001\u0001\u0001\t\re\u0002\u0001\u0015!\u00047\u0003ai\u0015N\\*uC\ndW-\u00138uKJ4\u0018\r\\'jGJ|7\u000f\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u0015\tX/Z;f+\u0005i\u0004c\u0001 D\u000b6\tqH\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t#\u0012\u0001B;uS2L!\u0001R \u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\u00111\u0015j\u0013(\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a\u0001V;qY\u0016\u0014\u0004CA\u000eM\u0013\tiED\u0001\bQe>$xN\u001c#fY&4XM]=\u0011\u0005=KV\"\u0001)\u000b\u0005E\u0013\u0016aB7fgN\fw-\u001a\u0006\u0003;MS!\u0001V+\u0002\tE\u0004\u0018\u000e\u001a\u0006\u0003-^\u000ba!\u00199bG\",'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[!\n9Q*Z:tC\u001e,\u0007b\u0002/\u0001\u0001\u0004%\t!X\u0001\ncV,W/Z0%KF$\"AX1\u0011\u0005\u0019{\u0016B\u00011H\u0005\u0011)f.\u001b;\t\u000f\t\\\u0016\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\t\r\u0011\u0004\u0001\u0015)\u0003>\u0003\u0019\tX/Z;fA!9a\r\u0001a\u0001\n\u00039\u0017\u0001\u00027bgR,\u0012!\u000b\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0003!a\u0017m\u001d;`I\u0015\fHC\u00010l\u0011\u001d\u0011\u0007.!AA\u0002%Ba!\u001c\u0001!B\u0013I\u0013!\u00027bgR\u0004\u0003bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0011a\u0016\u0014X.\u001b;t!\u0016\u00148+Z2p]\u0012,\u0012!\u001d\t\u0003\rJL!a]$\u0003\r\u0011{WO\u00197f\u0011\u0019)\b\u0001)A\u0005c\u0006\t\u0002/\u001a:nSR\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0011\t\u000f]\u0004!\u0019!C\u0001a\u0006!2\u000f^1cY\u0016Le\u000e^3sm\u0006dW*[2s_NDa!\u001f\u0001!\u0002\u0013\t\u0018!F:uC\ndW-\u00138uKJ4\u0018\r\\'jGJ|7\u000f\t\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0003a\u00198\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u000b\u0002{B\u0011aH`\u0005\u0003\u007f~\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nu\f\u0011d]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fA!I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011B\u0001\ng\u000eDW\rZ;mK\u0012,\"!a\u0003\u0011\u000b\u0019\u000bi!!\u0005\n\u0007\u0005=qI\u0001\u0004PaRLwN\u001c\u0019\u0005\u0003'\ti\u0002E\u0003?\u0003+\tI\"C\u0002\u0002\u0018}\u0012qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u00037\ti\u0002\u0004\u0001\u0005\u0019\u0005}\u0011\u0011EA\u0001\u0002\u0003\u0015\t!a\f\u0003\u0007}#\u0013\u0007\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\u0013\u0003)\u00198\r[3ek2,G\r\t\t\u0006\r\u00065\u0011q\u0005\u0019\u0005\u0003S\ti\u0003E\u0003?\u0003+\tY\u0003\u0005\u0003\u0002\u001c\u00055B\u0001DA\u0010\u0003C\t\t\u0011!A\u0003\u0002\u0005=\u0012\u0003BA\u0019\u0003o\u00012ARA\u001a\u0013\r\t)d\u0012\u0002\b\u001d>$\b.\u001b8h!\r1\u0015\u0011H\u0005\u0004\u0003w9%aA!os\"I\u0011q\b\u0001A\u0002\u0013%\u0011\u0011I\u0001\u000eg\u000eDW\rZ;mK\u0012|F%Z9\u0015\u0007y\u000b\u0019\u0005C\u0005c\u0003{\t\t\u00111\u0001\u0002FA)a)!\u0004\u0002HA\"\u0011\u0011JA'!\u0015q\u0014QCA&!\u0011\tY\"!\u0014\u0005\u0019\u0005}\u0011\u0011EA\u0001\u0002\u0003\u0015\t!a\f\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0013a\u00017pOV\u0011\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L,\u0002\u000bMdg\r\u000e6\n\t\u0005}\u0013\u0011\f\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003+\nA\u0001\\8hA!9\u0011q\r\u0001\u0005B\u0005%\u0014A\u00032fM>\u0014Xm\u00149f]R\ta\fC\u0004\u0002n\u0001!\t%!\u001b\u0002\u0017\t,gm\u001c:f\u00072|7/\u001a\u0005\b\u0003c\u0002A\u0011IA:\u0003\u001d\t7-];je\u0016$RAXA;\u0003sBq!a\u001e\u0002p\u0001\u00071*\u0001\u0005eK2Lg/\u001a:z\u0011\u0019\t\u0016q\u000ea\u0001\u001d\"9\u0011Q\u0010\u0001\u0005\n\u0005%\u0014!D:dQ\u0016$W\u000f\\3US6,'\u000fC\u0004\u0002\u0002\u0002!\t%!\u001b\u0002\u0007I,h\u000e")
public final class AMQPHrAsyncFlowController
extends AMQPFlowController
implements Runnable {
    private final double MinStableIntervalMicros;
    private BlockingQueue<Tuple2<ProtonDelivery, Message>> queue = new LinkedBlockingQueue<Tuple2<ProtonDelivery, Message>>();
    private Long last = Predef$.MODULE$.long2Long(0L);
    private final double permitsPerSecond;
    private final double stableIntervalMicros;
    private final ScheduledExecutorService scheduledExecutorService;
    private Option<ScheduledFuture<?>> scheduled;
    private final Logger log;

    private final double MinStableIntervalMicros() {
        return 100.0;
    }

    public BlockingQueue<Tuple2<ProtonDelivery, Message>> queue() {
        return this.queue;
    }

    public void queue_$eq(BlockingQueue<Tuple2<ProtonDelivery, Message>> x$1) {
        this.queue = x$1;
    }

    public Long last() {
        return this.last;
    }

    public void last_$eq(Long x$1) {
        this.last = x$1;
    }

    public double permitsPerSecond() {
        return this.permitsPerSecond;
    }

    public double stableIntervalMicros() {
        return this.stableIntervalMicros;
    }

    private ScheduledExecutorService scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    private Option<ScheduledFuture<?>> scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(Option<ScheduledFuture<?>> x$1) {
        this.scheduled = x$1;
    }

    private Logger log() {
        return this.log;
    }

    @Override
    public void beforeOpen() {
        this.last_$eq(Predef$.MODULE$.long2Long(0L));
        this.queue().clear();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permitsPerSecond ", ", stableIntervalMicros ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.permitsPerSecond()), BoxesRunTime.boxToDouble((double)this.stableIntervalMicros())})));
    }

    @Override
    public void beforeClose() {
        this.scheduledExecutorService().shutdown();
        this.scheduledExecutorService().awaitTermination(1L, TimeUnit.SECONDS);
        this.scheduled_$eq((Option<ScheduledFuture<?>>)None$.MODULE$);
    }

    @Override
    public void acquire(ProtonDelivery delivery, Message message) {
        Long now = Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime()));
        if (this.queue().isEmpty() && this.scheduled().isDefined()) {
            ((Future)this.scheduled().get()).cancel(false);
            this.scheduled_$eq((Option<ScheduledFuture<?>>)None$.MODULE$);
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer cancelled"})).s((Seq)Nil$.MODULE$));
        }
        if ((double)Predef$.MODULE$.Long2long(now) > (double)Predef$.MODULE$.Long2long(this.last()) + this.stableIntervalMicros() && this.queue().isEmpty()) {
            this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
            super.acquire(delivery, message);
        } else {
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--> Enqueue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(delivery.getTag())})));
            this.queue().put((Tuple2<ProtonDelivery, Message>)new Tuple2((Object)delivery, (Object)message));
            this.scheduleTimer();
        }
    }

    private void scheduleTimer() {
        if (this.scheduled().isEmpty()) {
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer scheduled every ", " us"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)this.stableIntervalMicros()))})));
            this.scheduled_$eq(Option$.MODULE$.apply(this.scheduledExecutorService().scheduleWithFixedDelay(this, (long)this.stableIntervalMicros(), (long)this.stableIntervalMicros(), TimeUnit.MICROSECONDS)));
        }
    }

    @Override
    public void run() {
        if (!this.queue().isEmpty()) {
            Tuple2<ProtonDelivery, Message> t = this.queue().take();
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<-- Dequeue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(((ProtonDelivery)t._1()).getTag())})));
            this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
            super.acquire((ProtonDelivery)t._1(), (Message)t._2());
        }
    }

    public AMQPHrAsyncFlowController(ProtonReceiver receiver, AMQPFlowControllerListener listener, Long maxRate) {
        super(receiver, listener);
        this.permitsPerSecond = Predef$.MODULE$.Long2long(maxRate);
        this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) < this.permitsPerSecond() ? 100.0 : (double)TimeUnit.SECONDS.toMicros(1L) / this.permitsPerSecond();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.scheduled = None$.MODULE$;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

