/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class HttpClientRequestImpl
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final String host;
    private final int port;
    private final HttpClientImpl client;
    private final HttpRequest request;
    private final VertxInternal vertx;
    private final HttpMethod method;
    private Handler<HttpClientResponse> respHandler;
    private Handler<Void> endHandler;
    private boolean chunked;
    private Handler<Void> continueHandler;
    private volatile ClientConnection conn;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean headWritten;
    private boolean completed;
    private ByteBuf pendingChunks;
    private int pendingMaxSize = -1;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private long currentTimeoutTimerId = -1L;
    private MultiMap headers;
    private boolean exceptionOccurred;
    private long lastDataReceived;
    private Object metric;

    HttpClientRequestImpl(HttpClientImpl client, HttpMethod method, String host, int port, String relativeURI, VertxInternal vertx) {
        this.host = host;
        this.port = port;
        this.client = client;
        this.request = new DefaultHttpRequest(this.toNettyHttpVersion(client.getOptions().getProtocolVersion()), this.toNettyHttpMethod(method), relativeURI, false);
        this.chunked = false;
        this.method = method;
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        Object object = this.getLock();
        synchronized (object) {
            if (handler != null) {
                this.checkComplete();
                this.respHandler = this.checkConnect(this.method, handler);
            } else {
                this.respHandler = null;
            }
            return this;
        }
    }

    @Override
    public HttpClientRequest pause() {
        return this;
    }

    @Override
    public HttpClientRequest resume() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        Object object = this.getLock();
        synchronized (object) {
            if (endHandler != null) {
                this.checkComplete();
            }
            this.endHandler = endHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl setChunked(boolean chunked) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            if (this.written > 0L) {
                throw new IllegalStateException("Cannot set chunked after data has been written on request");
            }
            if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
                this.chunked = chunked;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Object object = this.getLock();
        synchronized (object) {
            return this.chunked;
        }
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.headers == null) {
                this.headers = new HeadersAdaptor(this.request.headers());
            }
            return this.headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(String name, String value) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(Buffer chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            ByteBuf buf = chunk.getByteBuf();
            this.write(buf, false);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(String chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            return this.write(Buffer.buffer(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl write(String chunk, String enc) {
        Object object = this.getLock();
        synchronized (object) {
            Objects.requireNonNull(enc, "no null encoding accepted");
            this.checkComplete();
            this.checkResponseHandler();
            return this.write(Buffer.buffer(chunk, enc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            if (this.conn != null) {
                this.conn.doSetWriteQueueMaxSize(maxSize);
            } else {
                this.pendingMaxSize = maxSize;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            return this.conn != null && this.conn.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.drainHandler = handler;
            if (this.conn != null) {
                this.conn.getContext().runOnContext(v -> this.conn.handleInterestedOpsChanged());
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        Object object = this.getLock();
        synchronized (object) {
            if (handler != null) {
                this.checkComplete();
                this.exceptionHandler = t -> {
                    this.cancelOutstandingTimeoutTimer();
                    handler.handle((Throwable)t);
                };
            } else {
                this.exceptionHandler = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest continueHandler(Handler<Void> handler) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.continueHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl sendHead() {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            if (this.conn != null) {
                if (!this.headWritten) {
                    this.writeHead();
                }
            } else {
                this.connect();
                this.writeHead = true;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(String chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.end(Buffer.buffer(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(String chunk, String enc) {
        Object object = this.getLock();
        synchronized (object) {
            Objects.requireNonNull(enc, "no null encoding accepted");
            this.end(Buffer.buffer(chunk, enc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Buffer chunk) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            if (!this.chunked && !this.contentLengthSet()) {
                this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
            }
            this.write(chunk.getByteBuf(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.checkResponseHandler();
            this.write(Unpooled.EMPTY_BUFFER, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setTimeout(long timeoutMs) {
        Object object = this.getLock();
        synchronized (object) {
            this.cancelOutstandingTimeoutTimer();
            this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        Object object = this.getLock();
        synchronized (object) {
            this.checkComplete();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataReceived() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.currentTimeoutTimerId != -1L) {
                this.lastDataReceived = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.drainHandler != null) {
                try {
                    this.drainHandler.handle(null);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Object object = this.getLock();
        synchronized (object) {
            this.cancelOutstandingTimeoutTimer();
            this.exceptionOccurred = true;
            this.getExceptionHandler().handle(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponseImpl resp) {
        Object object = this.getLock();
        synchronized (object) {
            if (!this.exceptionOccurred) {
                this.cancelOutstandingTimeoutTimer();
                try {
                    if (resp.statusCode() == 100) {
                        if (this.continueHandler != null) {
                            this.continueHandler.handle(null);
                        }
                    } else {
                        if (this.respHandler != null) {
                            this.respHandler.handle(resp);
                        }
                        if (this.endHandler != null) {
                            this.endHandler.handle(null);
                        }
                    }
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    HttpRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock() {
        if (this.conn != null) {
            return this.conn;
        }
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.conn != null) {
                return this.conn;
            }
            return this;
        }
    }

    private Handler<HttpClientResponse> checkConnect(HttpMethod method, Handler<HttpClientResponse> handler) {
        if (method == HttpMethod.CONNECT) {
            handler = this.connectHandler(handler);
        }
        return handler;
    }

    private Handler<HttpClientResponse> connectHandler(Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return resp -> {
            HttpClientResponse response;
            if (resp.statusCode() == 200) {
                NetSocket socket = resp.netSocket();
                socket.pause();
                response = new HttpClientResponse((HttpClientResponse)resp, socket){
                    private boolean resumed;
                    final /* synthetic */ HttpClientResponse val$resp;
                    final /* synthetic */ NetSocket val$socket;
                    {
                        this.val$resp = httpClientResponse;
                        this.val$socket = netSocket;
                    }

                    @Override
                    public int statusCode() {
                        return this.val$resp.statusCode();
                    }

                    @Override
                    public String statusMessage() {
                        return this.val$resp.statusMessage();
                    }

                    @Override
                    public MultiMap headers() {
                        return this.val$resp.headers();
                    }

                    @Override
                    public String getHeader(String headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getHeader(CharSequence headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getTrailer(String trailerName) {
                        return this.val$resp.getTrailer(trailerName);
                    }

                    @Override
                    public MultiMap trailers() {
                        return this.val$resp.trailers();
                    }

                    @Override
                    public List<String> cookies() {
                        return this.val$resp.cookies();
                    }

                    @Override
                    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                        this.val$resp.bodyHandler(bodyHandler);
                        return this;
                    }

                    @Override
                    public synchronized NetSocket netSocket() {
                        if (!this.resumed) {
                            this.resumed = true;
                            HttpClientRequestImpl.this.vertx.getContext().runOnContext(v -> this.val$socket.resume());
                        }
                        return this.val$socket;
                    }

                    @Override
                    public HttpClientResponse endHandler(Handler<Void> endHandler) {
                        this.val$resp.endHandler((Handler)endHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse handler(Handler<Buffer> handler) {
                        this.val$resp.handler((Handler)handler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse pause() {
                        this.val$resp.pause();
                        return this;
                    }

                    @Override
                    public HttpClientResponse resume() {
                        this.val$resp.resume();
                        return this;
                    }

                    @Override
                    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                        this.val$resp.exceptionHandler((Handler)handler);
                        return this;
                    }
                };
            } else {
                response = resp;
            }
            responseHandler.handle(response);
        };
    }

    private Handler<Throwable> getExceptionHandler() {
        return this.exceptionHandler != null ? this.exceptionHandler : log::error;
    }

    private void cancelOutstandingTimeoutTimer() {
        if (this.currentTimeoutTimerId != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
        }
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        this.handleException(new TimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded"));
    }

    private synchronized void connect() {
        if (!this.connecting) {
            this.client.getConnection(this.port, this.host, conn -> {
                HttpClientRequestImpl httpClientRequestImpl = this;
                synchronized (httpClientRequestImpl) {
                    if (this.exceptionOccurred) {
                        conn.close();
                    } else if (!conn.isClosed()) {
                        this.connected((ClientConnection)conn);
                    } else {
                        this.connect();
                    }
                }
            }, this.exceptionHandler, this.vertx.getContext(), () -> this.exceptionOccurred);
            this.connecting = true;
        }
    }

    private void connected(ClientConnection conn) {
        conn.setCurrentRequest(this);
        this.conn = conn;
        this.metric = this.client.httpClientMetrics().requestBegin(conn.metric(), conn.localAddress(), conn.remoteAddress(), this);
        if (this.pendingMaxSize != -1) {
            conn.doSetWriteQueueMaxSize(this.pendingMaxSize);
        }
        if (this.pendingChunks != null) {
            ByteBuf pending = this.pendingChunks;
            this.pendingChunks = null;
            if (this.completed) {
                this.writeHeadWithContent(pending, true);
                conn.reportBytesWritten(this.written);
                if (this.respHandler != null) {
                    conn.endRequest();
                }
            } else {
                this.writeHeadWithContent(pending, false);
            }
        } else if (this.completed) {
            this.writeHeadWithContent(Unpooled.EMPTY_BUFFER, true);
            conn.reportBytesWritten(this.written);
            if (this.respHandler != null) {
                conn.endRequest();
            }
        } else if (this.writeHead) {
            this.writeHead();
        }
    }

    void reportResponseEnd(HttpClientResponseImpl resp) {
        HttpClientMetrics metrics = this.client.httpClientMetrics();
        if (metrics.isEnabled()) {
            metrics.responseEnd(this.metric, resp);
        }
    }

    private boolean contentLengthSet() {
        return this.headers != null && this.request.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    private void writeHead() {
        this.prepareHeaders();
        this.conn.writeToChannel(this.request);
        this.headWritten = true;
    }

    private void writeHeadWithContent(ByteBuf buf, boolean end) {
        this.prepareHeaders();
        if (end) {
            this.conn.writeToChannel(new AssembledFullHttpRequest(this.request, buf));
        } else {
            this.conn.writeToChannel(new AssembledHttpRequest(this.request, buf));
        }
        this.headWritten = true;
    }

    private void prepareHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.request.headers();
        headers.remove(HttpHeaders.TRANSFER_ENCODING);
        if (!headers.contains(HttpHeaders.HOST)) {
            this.request.headers().set(HttpHeaders.HOST, (Object)this.conn.hostHeader());
        }
        if (this.chunked) {
            io.netty.handler.codec.http.HttpHeaders.setTransferEncodingChunked(this.request);
        }
        if (this.client.getOptions().isTryUseCompression() && this.request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            this.request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
        if (!this.client.getOptions().isKeepAlive() && this.client.getOptions().getProtocolVersion() == HttpVersion.HTTP_1_1) {
            this.request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.client.getOptions().isKeepAlive() && this.client.getOptions().getProtocolVersion() == HttpVersion.HTTP_1_0) {
            this.request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
    }

    private void write(ByteBuf buff, boolean end) {
        int readableBytes = buff.readableBytes();
        if (readableBytes == 0 && !end) {
            return;
        }
        if (end) {
            this.completed = true;
        }
        if (!(end || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        this.written += (long)buff.readableBytes();
        if (this.conn == null) {
            if (this.pendingChunks == null) {
                this.pendingChunks = buff;
            } else {
                CompositeByteBuf pending;
                if (this.pendingChunks instanceof CompositeByteBuf) {
                    pending = (CompositeByteBuf)this.pendingChunks;
                } else {
                    pending = Unpooled.compositeBuffer();
                    pending.addComponent(this.pendingChunks).writerIndex(this.pendingChunks.writerIndex());
                    this.pendingChunks = pending;
                }
                pending.addComponent(buff).writerIndex(pending.writerIndex() + buff.writerIndex());
            }
            this.connect();
        } else {
            if (!this.headWritten) {
                this.writeHeadWithContent(buff, end);
            } else if (end) {
                if (buff.isReadable()) {
                    this.conn.writeToChannel(new DefaultLastHttpContent(buff, false));
                } else {
                    this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            } else {
                this.conn.writeToChannel(new DefaultHttpContent(buff));
            }
            if (end) {
                this.conn.reportBytesWritten(this.written);
                if (this.respHandler != null) {
                    this.conn.endRequest();
                }
            }
        }
    }

    private void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
        if (this.respHandler == null) {
            throw new IllegalStateException("You must set an handler for the HttpClientResponse before connecting");
        }
    }

    private io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        throw new IllegalArgumentException();
    }

    private io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }
}

