/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslAuthenticator;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;

public class ProtonSaslServerAuthenticatorImpl
implements ProtonSaslAuthenticator {
    private Sasl sasl;
    private Handler<ProtonConnection> handler;
    private ProtonConnectionImpl connection;

    public ProtonSaslServerAuthenticatorImpl(Handler<ProtonConnection> handler, ProtonConnectionImpl connection) {
        this.handler = handler;
        this.connection = connection;
    }

    @Override
    public void init(Transport transport) {
        this.sasl = transport.sasl();
        this.sasl.server();
        this.sasl.allowSkip(false);
        this.sasl.setMechanisms("ANONYMOUS");
    }

    @Override
    public boolean process() {
        if (this.sasl == null) {
            throw new IllegalStateException("Init was not called with the associated transport");
        }
        String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
        if (remoteMechanisms.length > 0) {
            String chosen = remoteMechanisms[0];
            if ("ANONYMOUS".equals(chosen)) {
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                this.handler.handle(this.connection);
                return true;
            }
            this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
        }
        return false;
    }
}

