/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.sasl.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.proton.sasl.ProtonSaslMechanism;
import io.vertx.proton.sasl.ProtonSaslMechanismFactory;
import io.vertx.proton.sasl.impl.ProtonSaslAnonymousFactoryImpl;
import io.vertx.proton.sasl.impl.ProtonSaslExternalFactoryImpl;
import io.vertx.proton.sasl.impl.ProtonSaslPlainFactoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class ProtonSaslMechanismFinderImpl {
    private static Logger LOG = LoggerFactory.getLogger(ProtonSaslMechanismFinderImpl.class);

    public static ProtonSaslMechanism findMatchingMechanism(String username, String password, Set<String> mechRestrictions, String ... remoteMechanisms) {
        ProtonSaslMechanism match = null;
        ArrayList<ProtonSaslMechanism> found = new ArrayList<ProtonSaslMechanism>();
        for (String remoteMechanism : remoteMechanisms) {
            ProtonSaslMechanismFactory factory = ProtonSaslMechanismFinderImpl.findMechanismFactory(remoteMechanism);
            if (factory == null) continue;
            ProtonSaslMechanism mech = factory.createMechanism();
            if (mechRestrictions != null && !mechRestrictions.contains(remoteMechanism)) {
                LOG.trace((Object)"Skipping {0} mechanism because it is not in the configured mechanisms restriction set", remoteMechanism);
                continue;
            }
            if (mech.isApplicable(username, password)) {
                found.add(mech);
                continue;
            }
            LOG.trace((Object)"Skipping {0} mechanism because the available credentials are not sufficient", mech);
        }
        if (!found.isEmpty()) {
            Collections.sort(found);
            match = (ProtonSaslMechanism)found.get(found.size() - 1);
        }
        LOG.trace((Object)"Best match for SASL auth was: {0}", match);
        return match;
    }

    protected static ProtonSaslMechanismFactory findMechanismFactory(String name) {
        if (name == null || name.isEmpty()) {
            LOG.warn("No SASL mechanism name was specified");
            return null;
        }
        ProtonSaslMechanismFactory factory = null;
        if ("PLAIN".equals(name)) {
            factory = new ProtonSaslPlainFactoryImpl();
        } else if ("ANONYMOUS".equals(name)) {
            factory = new ProtonSaslAnonymousFactoryImpl();
        } else if ("EXTERNAL".equals(name)) {
            factory = new ProtonSaslExternalFactoryImpl();
        }
        return factory;
    }
}

