/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.apache.spark.streaming.amqp.AMQPRateController;
import org.apache.spark.streaming.receiver.BlockGenerator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0007\u001b\tA\u0012)T)Q\u001b\u0006tW/\u00197SCR,7i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011\u0001B1ncBT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011!#Q'R!J\u000bG/Z\"p]R\u0014x\u000e\u001c7fe\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\bcY>\u001c7nR3oKJ\fGo\u001c:\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005e1\"A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0005\t/\u0001\u0011\t\u0011)A\u00057A\u0011AdI\u0007\u0002;)\u0011adH\u0001\u0007aJ|Go\u001c8\u000b\u0005\u0001\n\u0013!\u0002<feRD(\"\u0001\u0012\u0002\u0005%|\u0017B\u0001\u0013\u001e\u00059\u0001&o\u001c;p]J+7-Z5wKJDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDc\u0001\u0015*UA\u0011q\u0002\u0001\u0005\u0006'\u0015\u0002\r\u0001\u0006\u0005\u0006/\u0015\u0002\ra\u0007\u0005\bY\u0001\u0011\r\u0011\"\u0004.\u00039\u0019%/\u001a3jiN$UMZ1vYR,\u0012AL\b\u0002_u\u00111\u0001;\u0005\u0007c\u0001\u0001\u000bQ\u0002\u0018\u0002\u001f\r\u0013X\rZ5ug\u0012+g-Y;mi\u0002Bqa\r\u0001C\u0002\u00135A'\u0001\tDe\u0016$\u0017\u000e^:UQJ,7\u000f[8mIV\tQgD\u00017;\u0005\u0001\u0001B\u0002\u001d\u0001A\u00035Q'A\tDe\u0016$\u0017\u000e^:UQJ,7\u000f[8mI\u0002BqA\u000f\u0001A\u0002\u0013\u00051(A\u0003d_VtG/F\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\rIe\u000e\u001e\u0005\b\u0007\u0002\u0001\r\u0011\"\u0001E\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002F\u0011B\u0011QHR\u0005\u0003\u000fz\u0012A!\u00168ji\"9\u0011JQA\u0001\u0002\u0004a\u0014a\u0001=%c!11\n\u0001Q!\nq\naaY8v]R\u0004\u0003bB'\u0001\u0001\u0004%\taO\u0001\bGJ,G-\u001b;t\u0011\u001dy\u0005\u00011A\u0005\u0002A\u000b1b\u0019:fI&$8o\u0018\u0013fcR\u0011Q)\u0015\u0005\b\u0013:\u000b\t\u00111\u0001=\u0011\u0019\u0019\u0006\u0001)Q\u0005y\u0005A1M]3eSR\u001c\b\u0005C\u0003V\u0001\u0011\u0005c+\u0001\u0006cK\u001a|'/Z(qK:$\u0012!\u0012\u0005\u00061\u0002!\tEV\u0001\fE\u00164wN]3DY>\u001cX\rC\u0003[\u0001\u0011\u00053,\u0001\u0006p]\u0006\u001b\u0017/^5sK\u0012$2!\u0012/b\u0011\u0015i\u0016\f1\u0001_\u0003!!W\r\\5wKJL\bC\u0001\u000f`\u0013\t\u0001WD\u0001\bQe>$xN\u001c#fY&4XM]=\t\u000b\tL\u0006\u0019A2\u0002\u000f5,7o]1hKB\u0011A-[\u0007\u0002K*\u0011!M\u001a\u0006\u0003=\u001dT!\u0001\u001b\u0005\u0002\tE\u0004\u0018\u000eZ\u0005\u0003U\u0016\u0014q!T3tg\u0006<W\rC\u0003m\u0001\u0011\u0005c+A\np]RC'o\u001c;uY&twm\u0015;beR,G\rC\u0003o\u0001\u0011\u0005c+A\tp]RC'o\u001c;uY&tw-\u00128eK\u0012DQ\u0001\u001d\u0001\u0005BE\fAb\u001c8UQJ|G\u000f\u001e7j]\u001e$2!\u0012:t\u0011\u0015iv\u000e1\u0001_\u0011\u0015\u0011w\u000e1\u0001d\u0001")
public final class AMQPManualRateController
extends AMQPRateController {
    private final BlockGenerator blockGenerator;
    private final ProtonReceiver receiver;
    private final int CreditsDefault;
    private final int CreditsThreshold;
    private int count;
    private int credits;

    private final int CreditsDefault() {
        return 1000;
    }

    private final int CreditsThreshold() {
        return 0;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public int credits() {
        return this.credits;
    }

    public void credits_$eq(int x$1) {
        this.credits = x$1;
    }

    @Override
    public void beforeOpen() {
        this.count_$eq(0);
        if (this.blockGenerator.getCurrentLimit() != Long.MAX_VALUE && this.blockGenerator.getCurrentLimit() >= 0L) {
            this.credits_$eq((int)this.blockGenerator.getCurrentLimit());
        } else {
            this.credits_$eq(1000);
        }
        this.receiver.setPrefetch(0);
        this.receiver.flow(this.credits());
        super.beforeOpen();
    }

    @Override
    public void beforeClose() {
        super.beforeClose();
    }

    @Override
    public void onAcquired(ProtonDelivery delivery, Message message) {
        this.blockGenerator.addDataWithCallback((Object)message, (Object)delivery);
        this.count_$eq(this.count() + 1);
        if (this.count() >= this.credits() - 0) {
            this.receiver.flow(this.credits() - 0);
            this.count_$eq(0);
        }
        super.onAcquired(delivery, message);
    }

    @Override
    public void onThrottlingStarted() {
        super.onThrottlingStarted();
    }

    @Override
    public void onThrottlingEnded() {
        if (this.count() >= this.credits() - 0) {
            this.receiver.flow(this.credits() - 0);
            this.count_$eq(0);
        }
        super.onThrottlingEnded();
    }

    @Override
    public void onThrottling(ProtonDelivery delivery, Message message) {
        this.count_$eq(this.count() + 1);
        Rejected rejected = new Rejected();
        ErrorCondition errorCondition = new ErrorCondition(Symbol.valueOf("org.apache:amqp-recv-error"), "Throttling : Max rate limit exceeded");
        rejected.setError(errorCondition);
        delivery.disposition(rejected, true);
        super.onThrottling(delivery, message);
    }

    public AMQPManualRateController(BlockGenerator blockGenerator, ProtonReceiver receiver) {
        this.blockGenerator = blockGenerator;
        this.receiver = receiver;
        super(blockGenerator, receiver);
        this.count = 0;
        this.credits = 0;
    }
}

