/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.apache.spark.streaming.amqp.AMQPRateController;
import org.apache.spark.streaming.receiver.BlockGenerator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0007\u001b\tQ\u0012)T)Q!J,g-\u001a;dQJ\u000bG/Z\"p]R\u0014x\u000e\u001c7fe*\u00111\u0001B\u0001\u0005C6\f\bO\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\nB\u001bF\u0003&+\u0019;f\u0007>tGO]8mY\u0016\u0014\b\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u001d\tdwnY6HK:,'/\u0019;peB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\te\u0016\u001cW-\u001b<fe&\u0011\u0011D\u0006\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0011!9\u0002A!A!\u0002\u0013Y\u0002C\u0001\u000f$\u001b\u0005i\"B\u0001\u0010 \u0003\u0019\u0001(o\u001c;p]*\u0011\u0001%I\u0001\u0006m\u0016\u0014H\u000f\u001f\u0006\u0002E\u0005\u0011\u0011n\\\u0005\u0003Iu\u0011a\u0002\u0015:pi>t'+Z2fSZ,'\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q%R\u0003CA\b\u0001\u0011\u0015\u0019R\u00051\u0001\u0015\u0011\u00159R\u00051\u0001\u001c\u0011\u0015a\u0003\u0001\"\u0011.\u0003)\u0011WMZ8sK>\u0003XM\u001c\u000b\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t!QK\\5u\u0011\u0015)\u0004\u0001\"\u0011.\u0003-\u0011WMZ8sK\u000ecwn]3\t\u000b]\u0002A\u0011\t\u001d\u0002\u0015=t\u0017iY9vSJ,G\rF\u0002/syBQA\u000f\u001cA\u0002m\n\u0001\u0002Z3mSZ,'/\u001f\t\u00039qJ!!P\u000f\u0003\u001dA\u0013x\u000e^8o\t\u0016d\u0017N^3ss\")qH\u000ea\u0001\u0001\u00069Q.Z:tC\u001e,\u0007CA!G\u001b\u0005\u0011%BA D\u0015\tqBI\u0003\u0002F\u0011\u0005!\u0011\u000f]5e\u0013\t9%IA\u0004NKN\u001c\u0018mZ3\t\u000b%\u0003A\u0011I\u0017\u0002'=tG\u000b\u001b:piRd\u0017N\\4Ti\u0006\u0014H/\u001a3\t\u000b-\u0003A\u0011I\u0017\u0002#=tG\u000b\u001b:piRd\u0017N\\4F]\u0012,G\rC\u0003N\u0001\u0011\u0005c*\u0001\u0007p]RC'o\u001c;uY&tw\rF\u0002/\u001fBCQA\u000f'A\u0002mBQa\u0010'A\u0002\u0001\u0003")
public final class AMQPPrefetchRateController
extends AMQPRateController {
    private final BlockGenerator blockGenerator;
    private final ProtonReceiver receiver;

    @Override
    public void beforeOpen() {
        Object object = this.blockGenerator.getCurrentLimit() != Long.MAX_VALUE && this.blockGenerator.getCurrentLimit() >= 0L ? this.receiver.setPrefetch((int)this.blockGenerator.getCurrentLimit()) : BoxedUnit.UNIT;
        super.beforeOpen();
    }

    @Override
    public void beforeClose() {
        super.beforeClose();
    }

    @Override
    public void onAcquired(ProtonDelivery delivery, Message message) {
        this.blockGenerator.addDataWithCallback((Object)message, (Object)delivery);
        super.onAcquired(delivery, message);
    }

    @Override
    public void onThrottlingStarted() {
        super.onThrottlingStarted();
    }

    @Override
    public void onThrottlingEnded() {
        super.onThrottlingEnded();
    }

    @Override
    public void onThrottling(ProtonDelivery delivery, Message message) {
        Rejected rejected = new Rejected();
        ErrorCondition errorCondition = new ErrorCondition(Symbol.valueOf("org.apache:amqp-recv-error"), "Throttling : Max rate limit exceeded");
        rejected.setError(errorCondition);
        delivery.disposition(rejected, true);
        super.onThrottling(delivery, message);
    }

    public AMQPPrefetchRateController(BlockGenerator blockGenerator, ProtonReceiver receiver) {
        this.blockGenerator = blockGenerator;
        this.receiver = receiver;
        super(blockGenerator, receiver);
    }
}

