/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientConnection;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSinkChannel;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSourceChannel;
import io.undertow.protocols.ajp.AjpClientCPingStreamSinkChannel;
import io.undertow.protocols.ajp.AjpClientFramePriority;
import io.undertow.protocols.ajp.AjpClientRequestClientStreamSinkChannel;
import io.undertow.protocols.ajp.AjpClientResponseStreamSourceChannel;
import io.undertow.protocols.ajp.AjpResponseParser;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.Attachable;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class AjpClientChannel
extends AbstractFramedChannel<AjpClientChannel, AbstractAjpClientStreamSourceChannel, AbstractAjpClientStreamSinkChannel> {
    private final AjpResponseParser ajpParser;
    private AjpClientResponseStreamSourceChannel source;
    private AjpClientRequestClientStreamSinkChannel sink;
    private final List<ClientConnection.PingListener> pingListeners = new ArrayList<ClientConnection.PingListener>();
    boolean sinkDone = true;
    boolean sourceDone = true;
    private boolean lastFrameSent;
    private boolean lastFrameReceived;

    public AjpClientChannel(StreamConnection connectedStreamChannel, ByteBufferPool bufferPool, OptionMap settings) {
        super(connectedStreamChannel, bufferPool, AjpClientFramePriority.INSTANCE, null, settings);
        this.ajpParser = new AjpResponseParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractAjpClientStreamSourceChannel createChannel(FrameHeaderData frameHeaderData, PooledByteBuffer frameData) throws IOException {
        if (frameHeaderData instanceof SendHeadersResponse) {
            AjpClientResponseStreamSourceChannel sourceChannel;
            SendHeadersResponse h = (SendHeadersResponse)frameHeaderData;
            this.source = sourceChannel = new AjpClientResponseStreamSourceChannel(this, h.headers, h.statusCode, h.reasonPhrase, frameData, (int)frameHeaderData.getFrameLength());
            return sourceChannel;
        }
        if (frameHeaderData instanceof RequestBodyChunk) {
            RequestBodyChunk r = (RequestBodyChunk)frameHeaderData;
            this.sink.chunkRequested(r.getLength());
            frameData.close();
            return null;
        }
        if (frameHeaderData instanceof CpongResponse) {
            List<ClientConnection.PingListener> list = this.pingListeners;
            synchronized (list) {
                for (ClientConnection.PingListener i : this.pingListeners) {
                    try {
                        i.acknowledged();
                    }
                    catch (Throwable t) {
                        UndertowLogger.ROOT_LOGGER.debugf("Exception notifying ping listener", (Object)t);
                    }
                }
                this.pingListeners.clear();
            }
            return null;
        }
        frameData.close();
        throw new RuntimeException("TODO: unknown frame");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        this.ajpParser.parse(data);
        if (this.ajpParser.isComplete()) {
            try {
                AjpResponseParser parser = this.ajpParser;
                if (parser.prefix == 4) {
                    SendHeadersResponse sendHeadersResponse = new SendHeadersResponse(parser.statusCode, parser.reasonPhrase, parser.headers);
                    return sendHeadersResponse;
                }
                if (parser.prefix == 6) {
                    RequestBodyChunk requestBodyChunk = new RequestBodyChunk(parser.readBodyChunkSize);
                    return requestBodyChunk;
                }
                if (parser.prefix == 3) {
                    SendBodyChunk sendBodyChunk = new SendBodyChunk(parser.currentIntegerPart + 1);
                    return sendBodyChunk;
                }
                if (parser.prefix == 5) {
                    boolean persistent;
                    boolean bl = persistent = parser.currentIntegerPart != 0;
                    if (!persistent) {
                        this.lastFrameReceived = true;
                        this.lastFrameSent = true;
                    }
                    EndResponse endResponse = new EndResponse();
                    return endResponse;
                }
                if (parser.prefix == 9) {
                    CpongResponse cpongResponse = new CpongResponse();
                    return cpongResponse;
                }
                UndertowLogger.ROOT_LOGGER.debug("UNKOWN FRAME");
            }
            finally {
                this.ajpParser.reset();
            }
        }
        return null;
    }

    public AjpClientRequestClientStreamSinkChannel sendRequest(HttpString method, String path, HttpString protocol, HeaderMap headers, Attachable attachable, ChannelListener<AjpClientRequestClientStreamSinkChannel> finishListener) {
        AjpClientRequestClientStreamSinkChannel ajpClientRequestStreamSinkChannel;
        if (!this.sinkDone || !this.sourceDone) {
            throw UndertowMessages.MESSAGES.ajpRequestAlreadyInProgress();
        }
        this.sinkDone = false;
        this.sourceDone = false;
        this.sink = ajpClientRequestStreamSinkChannel = new AjpClientRequestClientStreamSinkChannel(this, finishListener, headers, path, method, protocol, attachable);
        this.source = null;
        return ajpClientRequestStreamSinkChannel;
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.lastFrameReceived;
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.lastFrameSent;
    }

    @Override
    protected void lastDataRead() {
        if (!this.lastFrameSent) {
            this.markReadsBroken(new ClosedChannelException());
            this.markWritesBroken(new ClosedChannelException());
        }
        this.lastFrameReceived = true;
        this.lastFrameSent = true;
        IoUtils.safeClose((Closeable)this);
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
    }

    @Override
    protected void closeSubChannels() {
        IoUtils.safeClose(this.source, this.sink);
    }

    @Override
    protected Collection<AbstractFramedStreamSourceChannel<AjpClientChannel, AbstractAjpClientStreamSourceChannel, AbstractAjpClientStreamSinkChannel>> getReceivers() {
        if (this.source == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.source);
    }

    @Override
    protected OptionMap getSettings() {
        return super.getSettings();
    }

    void sinkDone() {
        this.sinkDone = true;
        if (this.sourceDone) {
            this.sink = null;
            this.source = null;
        }
    }

    void sourceDone() {
        this.sourceDone = true;
        if (this.sinkDone) {
            this.sink = null;
            this.source = null;
        } else {
            this.sink.startDiscard();
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && !this.lastFrameSent && !this.lastFrameReceived;
    }

    @Override
    protected synchronized void recalculateHeldFrames() throws IOException {
        super.recalculateHeldFrames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPing(final ClientConnection.PingListener pingListener, long timeout, TimeUnit timeUnit) {
        AjpClientCPingStreamSinkChannel pingChannel = new AjpClientCPingStreamSinkChannel(this);
        try {
            pingChannel.shutdownWrites();
            if (!pingChannel.flush()) {
                pingChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<AbstractAjpClientStreamSinkChannel>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleException(AbstractAjpClientStreamSinkChannel channel, IOException exception) {
                        pingListener.failed(exception);
                        List<ClientConnection.PingListener> list = AjpClientChannel.this.pingListeners;
                        synchronized (list) {
                            AjpClientChannel.this.pingListeners.remove(pingListener);
                        }
                    }
                }));
                pingChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            pingListener.failed(e);
            return;
        }
        List<ClientConnection.PingListener> list = this.pingListeners;
        synchronized (list) {
            this.pingListeners.add(pingListener);
        }
        this.getIoThread().executeAfter(() -> {
            List<ClientConnection.PingListener> list = this.pingListeners;
            synchronized (list) {
                if (this.pingListeners.contains(pingListener)) {
                    this.pingListeners.remove(pingListener);
                    pingListener.failed(UndertowMessages.MESSAGES.pingTimeout());
                }
            }
        }, timeout, timeUnit);
    }

    class SendHeadersResponse
    implements FrameHeaderData {
        private final int statusCode;
        private final String reasonPhrase;
        private final HeaderMap headers;

        SendHeadersResponse(int statusCode, String reasonPhrase, HeaderMap headers) {
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
            this.headers = headers;
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return null;
        }
    }

    class RequestBodyChunk
    implements FrameHeaderData {
        private final int length;

        RequestBodyChunk(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return null;
        }
    }

    class CpongResponse
    implements FrameHeaderData {
        CpongResponse() {
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return null;
        }
    }

    class SendBodyChunk
    implements FrameHeaderData {
        private final int length;

        SendBodyChunk(int length) {
            this.length = length;
        }

        @Override
        public long getFrameLength() {
            return this.length;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return AjpClientChannel.this.source;
        }
    }

    class EndResponse
    implements FrameHeaderData {
        EndResponse() {
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return AjpClientChannel.this.source;
        }
    }
}

