/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.BufferWritableOutputStream;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.Headers;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class ServletOutputStreamImpl
extends ServletOutputStream
implements BufferWritableOutputStream {
    private final ServletRequestContext servletRequestContext;
    private PooledByteBuffer pooledBuffer;
    private ByteBuffer buffer;
    private Integer bufferSize;
    private StreamSinkChannel channel;
    private long written;
    private volatile int state;
    private volatile boolean asyncIoStarted;
    private AsyncContextImpl asyncContext;
    private WriteListener listener;
    private WriteChannelListener internalListener;
    private ByteBuffer[] buffersToWrite;
    private FileChannel pendingFile;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int FLAG_READY = 4;
    private static final int FLAG_DELEGATE_SHUTDOWN = 8;
    private static final int FLAG_IN_CALLBACK = 16;
    private static final int MAX_BUFFERS_TO_ALLOCATE = 6;
    private static final AtomicIntegerFieldUpdater<ServletOutputStreamImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ServletOutputStreamImpl.class, "state");

    public ServletOutputStreamImpl(ServletRequestContext servletRequestContext) {
        this.servletRequestContext = servletRequestContext;
    }

    public ServletOutputStreamImpl(ServletRequestContext servletRequestContext, int bufferSize) {
        this.bufferSize = bufferSize;
        this.servletRequestContext = servletRequestContext;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 1) || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (len < 1) {
            return;
        }
        int finalLength = (int)Math.min((long)len, this.remainingContentLength());
        if (this.listener == null) {
            ByteBuffer buffer = this.buffer();
            if (buffer.remaining() < finalLength) {
                this.writeTooLargeForBuffer(b, off, finalLength, buffer);
            } else {
                buffer.put(b, off, finalLength);
                if (buffer.remaining() == 0) {
                    this.writeBufferBlocking(false);
                }
            }
            this.updateWritten(finalLength);
        } else {
            this.writeAsync(b, off, finalLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTooLargeForBuffer(byte[] b, int off, int len, ByteBuffer buffer) throws IOException {
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            this.channel = channel = this.servletRequestContext.getExchange().getResponseChannel();
        }
        ByteBufferPool bufferPool = this.servletRequestContext.getExchange().getConnection().getByteBufferPool();
        ByteBuffer[] buffers = new ByteBuffer[7];
        PooledByteBuffer[] pooledBuffers = new PooledByteBuffer[6];
        try {
            buffers[0] = buffer;
            int bytesWritten = 0;
            int rem = buffer.remaining();
            buffer.put(b, bytesWritten + off, rem);
            buffer.flip();
            try {
                ByteBuffer cb;
                int toWrite;
                bytesWritten += rem;
                int bufferCount = 1;
                for (int i = 0; i < 6; ++i) {
                    PooledByteBuffer pooled;
                    pooledBuffers[bufferCount - 1] = pooled = bufferPool.allocate();
                    buffers[bufferCount++] = pooled.getBuffer();
                    toWrite = len - bytesWritten;
                    cb = pooled.getBuffer();
                    if (toWrite > cb.remaining()) {
                        rem = cb.remaining();
                        cb.put(b, bytesWritten + off, rem);
                        cb.flip();
                        bytesWritten += rem;
                        continue;
                    }
                    cb.put(b, bytesWritten + off, toWrite);
                    bytesWritten = len;
                    cb.flip();
                    break;
                }
                this.writeBlocking(buffers, 0, bufferCount, bytesWritten);
                while (bytesWritten < len) {
                    int oldBytesWritten = bytesWritten;
                    bufferCount = 0;
                    for (int i = 0; i < 7; ++i) {
                        cb = buffers[i];
                        cb.clear();
                        ++bufferCount;
                        toWrite = len - bytesWritten;
                        if (toWrite > cb.remaining()) {
                            rem = cb.remaining();
                            cb.put(b, bytesWritten + off, rem);
                            cb.flip();
                            bytesWritten += rem;
                            continue;
                        }
                        cb.put(b, bytesWritten + off, toWrite);
                        bytesWritten = len;
                        cb.flip();
                        break;
                    }
                    this.writeBlocking(buffers, 0, bufferCount, bytesWritten - oldBytesWritten);
                }
            }
            finally {
                if (buffer != null) {
                    buffer.compact();
                }
            }
        }
        finally {
            PooledByteBuffer p;
            for (int i = 0; i < pooledBuffers.length && (p = pooledBuffers[i]) != null; ++i) {
                p.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAsync(byte[] b, int off, int len) throws IOException {
        block12: {
            if (Bits.anyAreClear(this.state, 4)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            len = (int)Math.min((long)len, this.remainingContentLength());
            try {
                ByteBuffer buffer = this.buffer();
                if (buffer.remaining() > len) {
                    buffer.put(b, off, len);
                    break block12;
                }
                buffer.flip();
                boolean clearBuffer = true;
                try {
                    ByteBuffer userBuffer = ByteBuffer.wrap(b, off, len);
                    Buffer[] bufs = new ByteBuffer[]{buffer, userBuffer};
                    long toWrite = Buffers.remaining(bufs);
                    long written = 0L;
                    this.createChannel();
                    this.setFlags(2);
                    do {
                        long res = this.channel.write((ByteBuffer[])bufs);
                        written += res;
                        if (res != 0L) continue;
                        ByteBuffer copy = ByteBuffer.allocate(userBuffer.remaining());
                        copy.put(userBuffer);
                        copy.flip();
                        this.buffersToWrite = new ByteBuffer[]{buffer, copy};
                        this.clearFlags(4);
                        clearBuffer = false;
                        return;
                    } while (written < toWrite);
                }
                finally {
                    if (clearBuffer && buffer != null) {
                        buffer.compact();
                    }
                }
            }
            finally {
                this.updateWrittenAsync(len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer[] buffers) throws IOException {
        block30: {
            if (Bits.anyAreSet(this.state, 1) || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
                throw UndertowServletMessages.MESSAGES.streamIsClosed();
            }
            int len = 0;
            for (ByteBuffer buf : buffers) {
                len += buf.remaining();
            }
            if (len < 1) {
                return;
            }
            len = (int)Math.min((long)len, this.remainingContentLength());
            if (this.listener == null) {
                if (this.written == 0L && (long)len == this.servletRequestContext.getOriginalResponse().getContentLength()) {
                    if (this.channel == null) {
                        this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                    }
                    this.writeBlocking(buffers, 0, buffers.length, len);
                    this.setFlags(2);
                } else {
                    buffer = this.buffer();
                    if (len < buffer.remaining()) {
                        Buffers.copy(buffer, buffers, 0, buffers.length);
                    } else {
                        if (this.channel == null) {
                            this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                        }
                        if (buffer.position() == 0) {
                            this.writeBlocking(buffers, 0, buffers.length, len);
                        } else {
                            ByteBuffer[] newBuffers = new ByteBuffer[buffers.length + 1];
                            buffer.flip();
                            try {
                                newBuffers[0] = buffer;
                                System.arraycopy(buffers, 0, newBuffers, 1, buffers.length);
                                this.writeBlocking(newBuffers, 0, newBuffers.length, len + buffer.remaining());
                            }
                            finally {
                                if (buffer != null) {
                                    buffer.clear();
                                }
                            }
                        }
                        this.setFlags(2);
                    }
                }
                this.updateWritten(len);
            } else {
                if (Bits.anyAreClear(this.state, 4)) {
                    throw UndertowServletMessages.MESSAGES.streamNotReady();
                }
                try {
                    buffer = this.buffer();
                    if (buffer.remaining() > len) {
                        Buffers.copy(buffer, buffers, 0, buffers.length);
                        break block30;
                    }
                    Buffer[] bufs = new ByteBuffer[buffers.length + 1];
                    buffer.flip();
                    try {
                        bufs[0] = buffer;
                        System.arraycopy(buffers, 0, bufs, 1, buffers.length);
                        long toWrite = Buffers.remaining(bufs);
                        long written = 0L;
                        this.createChannel();
                        this.setFlags(2);
                        do {
                            long res = this.channel.write((ByteBuffer[])bufs);
                            written += res;
                            if (res != 0L) continue;
                            ByteBuffer copy = ByteBuffer.allocate((int)Buffers.remaining(buffers));
                            Buffers.copy(copy, buffers, 0, buffers.length);
                            copy.flip();
                            this.buffersToWrite = new ByteBuffer[]{buffer, copy};
                            this.clearFlags(4);
                            this.channel.resumeWrites();
                            return;
                        } while (written < toWrite);
                    }
                    finally {
                        if (buffer != null) {
                            buffer.compact();
                        }
                    }
                }
                finally {
                    this.updateWrittenAsync(len);
                }
            }
        }
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        this.write(new ByteBuffer[]{byteBuffer});
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            this.servletRequestContext.getOriginalResponse().setContentFullyWritten();
        }
    }

    long remainingContentLength() throws IOException {
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L) {
            return contentLength - this.written;
        }
        return Long.MAX_VALUE;
    }

    void updateWrittenAsync(long len) throws IOException {
        this.written += len;
        long contentLength = this.servletRequestContext.getOriginalResponse().getContentLength();
        if (contentLength != -1L && this.written >= contentLength) {
            this.servletRequestContext.getOriginalResponse().setContentFullyWritten();
        }
    }

    private boolean flushBufferAsync(boolean writeFinal) throws IOException {
        long toWrite;
        Buffer[] bufs = this.buffersToWrite;
        if (bufs == null) {
            ByteBuffer buffer = this.buffer;
            if (buffer == null || buffer.position() == 0) {
                return true;
            }
            buffer.flip();
            bufs = new ByteBuffer[]{buffer};
        }
        if ((toWrite = Buffers.remaining(bufs)) == 0L) {
            this.buffer.clear();
            return true;
        }
        this.setFlags(2);
        this.createChannel();
        long written = 0L;
        do {
            long res = writeFinal ? this.channel.writeFinal((ByteBuffer[])bufs) : this.channel.write((ByteBuffer[])bufs);
            written += res;
            if (res != 0L) continue;
            this.clearFlags(4);
            this.buffersToWrite = bufs;
            this.channel.resumeWrites();
            return false;
        } while (written < toWrite);
        this.buffer.clear();
        return true;
    }

    ByteBuffer underlyingBuffer() {
        if (Bits.anyAreSet(this.state, 1)) {
            return null;
        }
        return this.buffer();
    }

    @Override
    public void flush() throws IOException {
        block4: {
            if (this.servletRequestContext.getOriginalRequest().getDispatcherType() == DispatcherType.INCLUDE || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
                return;
            }
            if (this.servletRequestContext.getDeployment().getDeploymentInfo().isIgnoreFlush() && this.servletRequestContext.getExchange().isRequestComplete() && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null) {
                this.servletRequestContext.getOriginalResponse().setIgnoredFlushPerformed(true);
                return;
            }
            try {
                this.flushInternal();
            }
            catch (IOException ioe) {
                HttpServletRequestImpl request = this.servletRequestContext.getOriginalRequest();
                if (!request.isAsyncStarted() && request.getDispatcherType() != DispatcherType.ASYNC) break block4;
                this.servletRequestContext.getExchange().unDispatch();
                this.servletRequestContext.getOriginalRequest().getAsyncContextInternal().handleError(ioe);
                throw ioe;
            }
        }
    }

    public void flushInternal() throws IOException {
        if (this.listener == null) {
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            if (this.buffer != null && this.buffer.position() != 0) {
                this.writeBufferBlocking(false);
            }
            if (this.channel == null) {
                this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            }
            Channels.flushBlocking(this.channel);
        } else {
            if (Bits.anyAreClear(this.state, 4)) {
                return;
            }
            this.createChannel();
            if (this.buffer == null || this.buffer.position() == 0) {
                this.channel.flush();
                return;
            }
            this.setFlags(2);
            this.buffer.flip();
            try {
                long res;
                do {
                    res = this.channel.write(this.buffer);
                } while (this.buffer.hasRemaining() && res != 0L);
                if (!this.buffer.hasRemaining()) {
                    this.channel.flush();
                }
            }
            finally {
                if (this.buffer != null) {
                    this.buffer.compact();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFrom(FileChannel source) throws IOException {
        long remainingContentLength;
        if (Bits.anyAreSet(this.state, 1) || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        long startPosition = source.position();
        long count = source.size() - source.position();
        if (count > (remainingContentLength = this.remainingContentLength())) {
            count = remainingContentLength;
        }
        if (this.listener == null) {
            if (this.buffer != null && this.buffer.position() != 0) {
                this.writeBufferBlocking(false);
            }
            if (this.channel == null) {
                this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            }
            Channels.transferBlocking(this.channel, source, startPosition, count);
            this.updateWritten(count);
        } else {
            this.setFlags(2);
            this.createChannel();
            long pos = 0L;
            try {
                long end = pos + count;
                pos = startPosition;
                while (end - pos > 0L) {
                    long ret = this.channel.transferFrom(this.pendingFile, pos, end - pos);
                    if (ret <= 0L) {
                        this.clearFlags(4);
                        this.pendingFile = source;
                        this.channel.resumeWrites();
                        return;
                    }
                    pos += ret;
                }
            }
            finally {
                this.updateWrittenAsync(pos - startPosition);
            }
        }
    }

    private void writeBufferBlocking(boolean writeFinal) throws IOException {
        if (this.channel == null) {
            this.channel = this.servletRequestContext.getExchange().getResponseChannel();
        }
        this.buffer.flip();
        try {
            while (this.buffer.hasRemaining()) {
                int result = writeFinal ? this.channel.writeFinal(this.buffer) : this.channel.write(this.buffer);
                if (result != 0) continue;
                this.channel.awaitWritable();
            }
        }
        finally {
            if (this.buffer != null) {
                this.buffer.compact();
            }
            this.setFlags(2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.servletRequestContext.getOriginalRequest().getDispatcherType() == DispatcherType.INCLUDE || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            return;
        }
        if (this.listener == null) {
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            this.setFlags(1);
            this.clearFlags(4);
            if (Bits.allAreClear(this.state, 2) && this.channel == null && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null && this.servletRequestContext.getExchange().getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER) == null && this.servletRequestContext.getExchange().getAttachment(HttpAttachments.RESPONSE_TRAILERS) == null) {
                String contentLength = this.servletRequestContext.getOriginalResponse().getHeader("Content-Length");
                if (!(this.buffer != null || contentLength != null && "HEAD".equals(this.servletRequestContext.getOriginalRequest().getMethod()))) {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else if (this.buffer != null && contentLength == null) {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, this.buffer.position());
                }
            }
            try {
                if (this.buffer != null) {
                    this.writeBufferBlocking(true);
                }
                if (this.channel == null) {
                    this.channel = this.servletRequestContext.getExchange().getResponseChannel();
                }
                this.setFlags(8);
                StreamSinkChannel channel = this.channel;
                if (channel == null) return;
                channel.shutdownWrites();
                Channels.flushBlocking(channel);
                return;
            }
            catch (IOException | Error | RuntimeException e) {
                IoUtils.safeClose((Closeable)this.channel);
                throw e;
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.close();
                    this.buffer = null;
                } else {
                    this.buffer = null;
                }
            }
        } else {
            this.closeAsync();
        }
    }

    public void closeAsync() throws IOException {
        if (Bits.anyAreSet(this.state, 1) || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            return;
        }
        if (!this.servletRequestContext.getExchange().isInIoThread()) {
            this.servletRequestContext.getExchange().getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServletOutputStreamImpl.this.closeAsync();
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.closeAsyncFailed(e);
                    }
                }
            });
            return;
        }
        try {
            this.setFlags(1);
            this.clearFlags(4);
            if (Bits.allAreClear(this.state, 2) && this.channel == null && this.servletRequestContext.getOriginalResponse().getHeader("Transfer-Encoding") == null && this.servletRequestContext.getExchange().getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER) == null && this.servletRequestContext.getExchange().getAttachment(HttpAttachments.RESPONSE_TRAILERS) == null) {
                String contentLength = this.servletRequestContext.getOriginalResponse().getHeader("Content-Length");
                if (!(this.buffer != null || contentLength != null && "HEAD".equals(this.servletRequestContext.getOriginalRequest().getMethod()))) {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else if (this.buffer != null && contentLength == null) {
                    this.servletRequestContext.getExchange().getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(this.buffer.position()));
                }
            }
            this.createChannel();
            if (this.buffer != null) {
                if (!this.flushBufferAsync(true)) {
                    return;
                }
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.close();
                    this.buffer = null;
                } else {
                    this.buffer = null;
                }
            }
            this.channel.shutdownWrites();
            this.setFlags(8);
            if (!this.channel.flush()) {
                this.channel.resumeWrites();
            }
        }
        catch (IOException | Error | RuntimeException e) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
                this.buffer = null;
            }
            throw e;
        }
    }

    private void createChannel() {
        if (this.channel == null) {
            this.channel = this.servletRequestContext.getExchange().getResponseChannel();
            if (this.internalListener != null) {
                this.channel.getWriteSetter().set(this.internalListener);
            }
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        if (this.bufferSize != null) {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize);
            return this.buffer;
        }
        this.pooledBuffer = this.servletRequestContext.getExchange().getConnection().getByteBufferPool().allocate();
        this.buffer = this.pooledBuffer.getBuffer();
        return this.buffer;
    }

    public void resetBuffer() {
        if (Bits.allAreClear(this.state, 2)) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.pooledBuffer = null;
            }
        } else {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.buffer = null;
        this.written = 0L;
    }

    public void setBufferSize(int size) {
        if (this.buffer != null || this.servletRequestContext.getOriginalResponse().isTreatAsCommitted()) {
            throw UndertowServletMessages.MESSAGES.contentHasBeenWritten();
        }
        this.bufferSize = size;
    }

    public boolean isClosed() {
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public boolean isReady() {
        if (this.listener == null) {
            throw UndertowServletMessages.MESSAGES.streamNotInAsyncMode();
        }
        if (!this.asyncIoStarted) {
            return false;
        }
        if (!Bits.anyAreSet(this.state, 4)) {
            if (this.channel != null) {
                this.channel.resumeWrites();
            }
            return false;
        }
        return true;
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        HttpServletRequestImpl servletRequest = this.servletRequestContext.getOriginalRequest();
        if (!servletRequest.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = (AsyncContextImpl)servletRequest.getAsyncContext();
        this.listener = writeListener;
        this.internalListener = new WriteChannelListener();
        if (this.channel != null) {
            this.channel.getWriteSetter().set(this.internalListener);
        }
        this.asyncContext.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                ServletOutputStreamImpl.this.asyncIoStarted = true;
                if (ServletOutputStreamImpl.this.channel == null) {
                    ServletOutputStreamImpl.this.servletRequestContext.getExchange().getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            ServletOutputStreamImpl.this.internalListener.handleEvent((StreamSinkChannel)null);
                        }
                    });
                } else {
                    ServletOutputStreamImpl.this.channel.resumeWrites();
                }
            }
        });
    }

    ServletRequestContext getServletRequestContext() {
        return this.servletRequestContext;
    }

    private void setFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old | flags)) {
        }
    }

    private void clearFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old & ~flags)) {
        }
    }

    private void writeBlocking(ByteBuffer[] buffers, int offs, int len, int bytesToWrite) throws IOException {
        int totalWritten = 0;
        while ((totalWritten = (int)((long)totalWritten + Channels.writeBlocking(this.channel, buffers, 0, len))) < bytesToWrite) {
        }
    }

    private class WriteChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private WriteChannelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSinkChannel aChannel) {
            if (Bits.anyAreSet(ServletOutputStreamImpl.this.state, 8)) {
                try {
                    ServletOutputStreamImpl.this.channel.flush();
                    return;
                }
                catch (Throwable t) {
                    this.handleError(t);
                    return;
                }
            }
            if (ServletOutputStreamImpl.this.buffersToWrite != null) {
                long toWrite = Buffers.remaining(ServletOutputStreamImpl.this.buffersToWrite);
                long written = 0L;
                if (toWrite > 0L) {
                    do {
                        try {
                            long res = ServletOutputStreamImpl.this.channel.write(ServletOutputStreamImpl.this.buffersToWrite);
                            written += res;
                            if (res == 0L) {
                                return;
                            }
                        }
                        catch (Throwable t) {
                            this.handleError(t);
                            return;
                        }
                    } while (written < toWrite);
                }
                ServletOutputStreamImpl.this.buffersToWrite = null;
                ServletOutputStreamImpl.this.buffer.clear();
            }
            if (ServletOutputStreamImpl.this.pendingFile != null) {
                try {
                    long size = ServletOutputStreamImpl.this.pendingFile.size();
                    long pos = ServletOutputStreamImpl.this.pendingFile.position();
                    while (size - pos > 0L) {
                        long ret = ServletOutputStreamImpl.this.channel.transferFrom(ServletOutputStreamImpl.this.pendingFile, pos, size - pos);
                        if (ret <= 0L) {
                            ServletOutputStreamImpl.this.pendingFile.position(pos);
                            return;
                        }
                        pos += ret;
                    }
                    ServletOutputStreamImpl.this.pendingFile = null;
                }
                catch (Throwable t) {
                    this.handleError(t);
                    return;
                }
            }
            if (Bits.anyAreSet(ServletOutputStreamImpl.this.state, 1)) {
                try {
                    if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                        ServletOutputStreamImpl.this.pooledBuffer.close();
                        ServletOutputStreamImpl.this.buffer = null;
                    } else {
                        ServletOutputStreamImpl.this.buffer = null;
                    }
                    ServletOutputStreamImpl.this.channel.shutdownWrites();
                    ServletOutputStreamImpl.this.setFlags(8);
                    ServletOutputStreamImpl.this.channel.flush();
                }
                catch (Throwable t) {
                    this.handleError(t);
                    return;
                }
            }
            if (ServletOutputStreamImpl.this.asyncContext.isDispatched()) {
                ServletOutputStreamImpl.this.channel.suspendWrites();
                return;
            }
            ServletOutputStreamImpl.this.setFlags(4);
            try {
                ServletOutputStreamImpl.this.setFlags(16);
                if (ServletOutputStreamImpl.this.channel != null) {
                    ServletOutputStreamImpl.this.channel.suspendWrites();
                }
                ServletOutputStreamImpl.this.servletRequestContext.getCurrentServletContext().invokeOnWritePossible(ServletOutputStreamImpl.this.servletRequestContext.getExchange(), ServletOutputStreamImpl.this.listener);
            }
            catch (Throwable e) {
                IoUtils.safeClose((Closeable)ServletOutputStreamImpl.this.channel);
            }
            finally {
                ServletOutputStreamImpl.this.clearFlags(16);
            }
        }

        private void handleError(final Throwable t) {
            try {
                ServletOutputStreamImpl.this.servletRequestContext.getCurrentServletContext().invokeRunnable(ServletOutputStreamImpl.this.servletRequestContext.getExchange(), new Runnable(){

                    @Override
                    public void run() {
                        ServletOutputStreamImpl.this.listener.onError(t);
                    }
                });
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(ServletOutputStreamImpl.this.channel, ServletOutputStreamImpl.this.servletRequestContext.getExchange().getConnection());
                if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                    ServletOutputStreamImpl.this.pooledBuffer.close();
                    ServletOutputStreamImpl.this.pooledBuffer = null;
                    ServletOutputStreamImpl.this.buffer = null;
                }
                throw throwable;
            }
            IoUtils.safeClose(ServletOutputStreamImpl.this.channel, ServletOutputStreamImpl.this.servletRequestContext.getExchange().getConnection());
            if (ServletOutputStreamImpl.this.pooledBuffer != null) {
                ServletOutputStreamImpl.this.pooledBuffer.close();
                ServletOutputStreamImpl.this.pooledBuffer = null;
                ServletOutputStreamImpl.this.buffer = null;
            }
        }
    }
}

