/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;

final class SendHandlerAdapter
implements WebSocketCallback<Void> {
    private final Session session;
    private final SendHandler handler;
    private volatile boolean done;

    SendHandlerAdapter(Session session, SendHandler handler) {
        this.session = session;
        this.handler = handler;
    }

    @Override
    public void complete(WebSocketChannel channel, Void context) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.handler.onResult(new SendResult(this.session));
    }

    @Override
    public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.handler.onResult(new SendResult(this.session, throwable));
    }
}

