/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.encoding.ContentEncoding;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.QValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EncodingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final Map<String, EncodingMapping> encodingMap = new CopyOnWriteMap<String, EncodingMapping>();
    private volatile HttpHandler noEncodingHandler = ResponseCodeHandler.HANDLE_406;
    private static final String IDENTITY = "identity";

    public EncodingHandler(HttpHandler next) {
        this.next = next;
    }

    public EncodingHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues res = exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        HttpHandler nextHandler = this.next;
        if (res == null || res.isEmpty()) {
            if (nextHandler != null) {
                HttpHandlers.executeHandler(nextHandler, exchange);
            } else {
                HttpHandlers.executeHandler(this.noEncodingHandler, exchange);
            }
            return;
        }
        ArrayList<EncodingMapping> resultingMappings = new ArrayList<EncodingMapping>();
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            ArrayList<EncodingMapping> available = new ArrayList<EncodingMapping>();
            boolean includesIdentity = false;
            boolean isQValue0 = false;
            for (QValueParser.QValueResult value : result) {
                EncodingMapping encoding;
                if (value.getValue().equals("*")) {
                    includesIdentity = true;
                    encoding = new EncodingMapping(IDENTITY, ContentEncodingProvider.IDENTITY, 0, Predicates.truePredicate());
                } else {
                    encoding = this.encodingMap.get(value.getValue());
                }
                if (value.isQValueZero()) {
                    isQValue0 = true;
                }
                if (encoding == null) continue;
                available.add(encoding);
            }
            if (isQValue0) {
                if (!resultingMappings.isEmpty()) continue;
                if (includesIdentity) {
                    HttpHandlers.executeHandler(this.noEncodingHandler, exchange);
                    return;
                }
                HttpHandlers.executeHandler(nextHandler, exchange);
                return;
            }
            if (available.isEmpty()) continue;
            Collections.sort(available, Collections.reverseOrder());
            resultingMappings.addAll(available);
        }
        if (!resultingMappings.isEmpty()) {
            ContentEncoding contentEncoding = new ContentEncoding(exchange, resultingMappings);
            exchange.addResponseWrapper(contentEncoding);
            exchange.putAttachment(ContentEncoding.CONENT_ENCODING, contentEncoding);
        }
        HttpHandlers.executeHandler(nextHandler, exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EncodingHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public synchronized EncodingHandler addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority) {
        this.addEncodingHandler(encoding, encoder, priority, Predicates.truePredicate());
        return this;
    }

    public synchronized EncodingHandler addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority, Predicate<HttpServerExchange> enabledPredicate) {
        this.encodingMap.put(encoding, new EncodingMapping(encoding, encoder, priority, enabledPredicate));
        return this;
    }

    public synchronized EncodingHandler removeEncodingHandler(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }

    public HttpHandler getNoEncodingHandler() {
        return this.noEncodingHandler;
    }

    public EncodingHandler setNoEncodingHandler(HttpHandler noEncodingHandler) {
        HttpHandlers.handlerNotNull(noEncodingHandler);
        this.noEncodingHandler = noEncodingHandler;
        return this;
    }
}

