/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpResponseParser;
import io.undertow.client.PendingHttpRequest;
import io.undertow.client.ResponseParseState;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class ResponseParserResumeTestCase {
    public static final String DATA = "HTTP/1.1 200 OK\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\nHostee:another\r\nAccept-garbage:   a\r\n\r\ntttt";

    @Test
    public void testMethodSplit() {
        byte[] in = DATA.getBytes();
        for (int i = 0; i < in.length - 4; ++i) {
            try {
                this.testResume(i, in);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Test failed at split " + i, e);
            }
        }
    }

    @Test
    public void testOneCharacterAtATime() {
        byte[] in = DATA.getBytes();
        ResponseParseState context = new ResponseParseState();
        PendingHttpRequest result = new PendingHttpRequest(null, null, false, false, false, false, null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(1);
        while (context.state != 6) {
            HttpResponseParser.INSTANCE.handle(buffer, context, result);
            buffer.limit(buffer.limit() + 1);
        }
        this.runAssertions(result, context);
    }

    private void testResume(int split, byte[] in) {
        ResponseParseState context = new ResponseParseState();
        PendingHttpRequest result = new PendingHttpRequest(null, null, false, false, false, false, null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(split);
        HttpResponseParser.INSTANCE.handle(buffer, context, result);
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        buffer.limit(buffer.capacity());
        HttpResponseParser.INSTANCE.handle(buffer, context, result);
        this.runAssertions(result, context);
        Assert.assertEquals((long)4L, (long)buffer.remaining());
    }

    private void runAssertions(PendingHttpRequest result, ResponseParseState context) {
        Assert.assertEquals((long)200L, (long)result.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)result.getReasonPhrase());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getResponseHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)"some value", (Object)result.getResponseHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((Object)"another", (Object)result.getResponseHeaders().getFirst(new HttpString("Hostee")));
        Assert.assertEquals((Object)"a", (Object)result.getResponseHeaders().getFirst(new HttpString("Accept-garbage")));
        Assert.assertEquals((long)4L, (long)result.getResponseHeaders().getHeaderNames().size());
        Assert.assertEquals((long)6L, (long)context.state);
    }
}

