/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpRequestParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ParseState;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.Option;
import org.xnio.OptionMap;

public class ParserResumeTestCase {
    public static final String DATA = "POST http://www.somehost.net/apath+with+spaces%20and%20I%C3%B1t%C3%ABrn%C3%A2ti%C3%B4n%C3%A0li%C5%BE%C3%A6ti%C3%B8n?key1=value1&key2=I%C3%B1t%C3%ABrn%C3%A2ti%C3%B4n%C3%A0li%C5%BE%C3%A6ti%C3%B8n HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\nHostee:another\r\nAccept-garbage:   a\r\n\r\ntttt";
    public static final HttpRequestParser PARSER = HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true));

    @Test
    public void testMethodSplit() {
        byte[] in = DATA.getBytes();
        for (int i = 0; i < in.length - 4; ++i) {
            try {
                this.testResume(i, in);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Test failed at split " + i, e);
            }
        }
    }

    @Test
    public void testOneCharacterAtATime() {
        byte[] in = DATA.getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(1);
        while (context.state != 8) {
            PARSER.handle(buffer, context, result);
            buffer.limit(buffer.limit() + 1);
        }
        this.runAssertions(result, context);
    }

    private void testResume(int split, byte[] in) {
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(split);
        PARSER.handle(buffer, context, result);
        buffer.limit(buffer.capacity());
        PARSER.handle(buffer, context, result);
        this.runAssertions(result, context);
        Assert.assertEquals((long)4L, (long)buffer.remaining());
    }

    private void runAssertions(HttpServerExchange result, ParseState context) {
        Assert.assertSame((Object)Methods.POST, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/apath with spaces and I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0li\u017e\u00e6ti\u00f8n", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/apath+with+spaces%20and%20I%C3%B1t%C3%ABrn%C3%A2ti%C3%B4n%C3%A0li%C5%BE%C3%A6ti%C3%B8n", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getRequestHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)"some value", (Object)result.getRequestHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((Object)"another", (Object)result.getRequestHeaders().getFirst(new HttpString("Hostee")));
        Assert.assertEquals((Object)"a", (Object)result.getRequestHeaders().getFirst(new HttpString("Accept-garbage")));
        Assert.assertEquals((long)4L, (long)result.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((long)8L, (long)context.state);
        Assert.assertEquals((Object)"key1=value1&key2=I%C3%B1t%C3%ABrn%C3%A2ti%C3%B4n%C3%A0li%C5%BE%C3%A6ti%C3%B8n", (Object)result.getQueryString());
        Assert.assertEquals((Object)"value1", ((Deque)result.getQueryParameters().get("key1")).getFirst());
        Assert.assertEquals((Object)"I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0li\u017e\u00e6ti\u00f8n", ((Deque)result.getQueryParameters().get("key2")).getFirst());
    }
}

