/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import java.io.IOException;
import java.net.Socket;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class BadRequestTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                exchange.setResponseCode(200);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadRequest() throws IOException {
        String request = "POST /\r HTTP/1.1\r\nTrailer:foo, bar\r\nTransfer-Encoding: chunked\r\n\r\n9\r\nabcdefghi\r\n0\r\nfoo: fooVal\r\n bar: barVal\r\n\r\n";
        String response1 = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
        try (Socket s = new Socket(DefaultServer.getDefaultServerAddress().getAddress(), DefaultServer.getDefaultServerAddress().getPort());){
            int r;
            s.getOutputStream().write(request.getBytes());
            StringBuilder sb = new StringBuilder();
            int read = 0;
            byte[] buf = new byte[100];
            while (read < response1.length() && (r = s.getInputStream().read(buf)) > 0) {
                if (r <= 0) continue;
                read += r;
                sb.append(new String(buf, 0, r));
            }
            Assert.assertEquals((Object)response1, (Object)sb.toString());
        }
    }
}

