/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.junit.Assert;
import org.xnio.FutureResult;

public final class FrameChecker
implements WebSocketTestClient.FrameListener {
    private final Class<? extends WebSocketFrame> clazz;
    private final byte[] expectedPayload;
    private final FutureResult<?> latch;

    public FrameChecker(Class<? extends WebSocketFrame> clazz, byte[] expectedPayload, FutureResult<?> latch) {
        this.clazz = clazz;
        this.expectedPayload = expectedPayload;
        this.latch = latch;
    }

    @Override
    public void onFrame(WebSocketFrame frame) {
        try {
            Assert.assertTrue((boolean)this.clazz.isInstance(frame));
            ChannelBuffer buf = frame.getBinaryData();
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            Assert.assertArrayEquals((byte[])this.expectedPayload, (byte[])data);
            this.latch.setResult(null);
        }
        catch (Throwable e) {
            this.latch.setException(new IOException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        try {
            t.printStackTrace();
            Assert.fail();
        }
        finally {
            this.latch.setException(new IOException(t));
        }
    }
}

