/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AjpResponseConduit;
import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class AjpRequestConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private static final ByteBuffer READ_BODY_CHUNK;
    private final AjpResponseConduit ajpResponseConduit;
    private final Long size;
    private static final int HEADER_LENGTH = 6;
    private final ByteBuffer headerBuffer = ByteBuffer.allocateDirect(6);
    private final ConduitListener<? super AjpRequestConduit> finishListener;
    private long remaining;
    private long state;
    private static final long STATE_READING = Long.MIN_VALUE;
    private static final long STATE_SEND_REQUIRED = 0x4000000000000000L;
    private static final long STATE_FINISHED = 0x2000000000000000L;
    private static final long STATE_MASK;

    public AjpRequestConduit(StreamSourceConduit delegate, AjpResponseConduit ajpResponseConduit, Long size, ConduitListener<? super AjpRequestConduit> finishListener) {
        super(delegate);
        this.ajpResponseConduit = ajpResponseConduit;
        this.size = size;
        this.finishListener = finishListener;
        if (size == null) {
            this.state = 0x4000000000000000L;
            this.remaining = -1L;
        } else if (size == 0L) {
            this.state = 0x2000000000000000L;
            this.remaining = 0L;
        } else {
            this.state = Long.MIN_VALUE;
            this.remaining = size;
        }
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < length; ++i) {
            while (dsts[i].hasRemaining()) {
                int r = this.read(dsts[i]);
                if (r <= 0 && total > 0L) {
                    return total;
                }
                if (r <= 0) {
                    return r;
                }
                total += (long)r;
            }
        }
        return total;
    }

    public int read(ByteBuffer dst) throws IOException {
        long state = this.state;
        if (Bits.anyAreSet((long)state, (long)0x2000000000000000L)) {
            return -1;
        }
        if (Bits.anyAreSet((long)state, (long)0x4000000000000000L)) {
            state = this.state = state & STATE_MASK | Long.MIN_VALUE;
            if (!this.ajpResponseConduit.doGetRequestBodyChunk(READ_BODY_CHUNK.duplicate(), this)) {
                return 0;
            }
        }
        if (Bits.anyAreSet((long)state, (long)Long.MIN_VALUE)) {
            return this.doRead(dst, state);
        }
        assert (0x2000000000000000L == state);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(ByteBuffer dst, long state) throws IOException {
        long chunkRemaining;
        ByteBuffer headerBuffer = this.headerBuffer;
        long headerRead = 6 - headerBuffer.remaining();
        long remaining = this.remaining;
        if (remaining == 0L) {
            this.state = 0x2000000000000000L;
            if (this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
            return -1;
        }
        if (headerRead != 6L) {
            int read = ((StreamSourceConduit)this.next).read(headerBuffer);
            if (read == -1) {
                return read;
            }
            if (headerBuffer.hasRemaining()) {
                return 0;
            }
            headerBuffer.flip();
            byte b1 = headerBuffer.get();
            byte b2 = headerBuffer.get();
            assert (b1 == 18);
            assert (b2 == 52);
            headerBuffer.get();
            headerBuffer.get();
            b1 = headerBuffer.get();
            b2 = headerBuffer.get();
            chunkRemaining = (b1 & 0xFF) << 8 | b2 & 0xFF;
            if (chunkRemaining == 0L) {
                this.remaining = 0L;
                this.state = 0x2000000000000000L;
                if (this.finishListener != null) {
                    this.finishListener.handleEvent(this);
                }
                return -1;
            }
        } else {
            chunkRemaining = this.state & STATE_MASK;
        }
        int limit = dst.limit();
        try {
            if ((long)limit > chunkRemaining) {
                dst.limit((int)((long)dst.position() + chunkRemaining));
            }
            int read = ((StreamSourceConduit)this.next).read(dst);
            chunkRemaining -= (long)read;
            if (remaining != -1L) {
                remaining -= (long)read;
            }
            if (remaining == 0L) {
                this.state = 0x2000000000000000L;
                if (this.finishListener != null) {
                    this.finishListener.handleEvent(this);
                }
            } else if (chunkRemaining == 0L) {
                headerBuffer.clear();
                this.state = 0x4000000000000000L;
            } else {
                this.state = state & (STATE_MASK ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
            }
            int n = read;
            return n;
        }
        finally {
            this.remaining = remaining;
            dst.limit(limit);
        }
    }

    public void awaitReadable() throws IOException {
        if (Bits.anyAreSet((long)this.state, (long)Long.MIN_VALUE)) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((long)this.state, (long)Long.MIN_VALUE)) {
            ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
        }
    }

    static {
        ByteBuffer readBody = ByteBuffer.allocateDirect(7);
        readBody.put((byte)65);
        readBody.put((byte)66);
        readBody.put((byte)0);
        readBody.put((byte)3);
        readBody.put((byte)6);
        readBody.put((byte)31);
        readBody.put((byte)-6);
        readBody.flip();
        READ_BODY_CHUNK = readBody;
        STATE_MASK = Bits.longBitMask((int)0, (int)60);
    }
}

