/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.FileUtils;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;

@RunWith(value=DefaultServer.class)
public class MultipartFormDataParserTestCase {
    @BeforeClass
    public static void setup() {
        HttpHandler fd = new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                FormDataParser parser = FormParserFactory.builder().build().createParser(exchange);
                try {
                    FormData.FormValue file;
                    FormData data = parser.parseBlocking();
                    exchange.setResponseCode(500);
                    if (data.getFirst("formValue").getValue().equals("myValue") && (file = data.getFirst("file")).isFile() && file.getFile() != null && FileUtils.readFile(file.getFile()).startsWith("file contents")) {
                        exchange.setResponseCode(200);
                    }
                    exchange.endExchange();
                }
                catch (IOException e) {
                    exchange.setResponseCode(500);
                    exchange.endExchange();
                }
                finally {
                    IoUtils.safeClose((Closeable)parser);
                }
            }
        };
        DefaultServer.setRootHandler(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUpload() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", Charset.forName("UTF-8")));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultipartFormDataParserTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

