/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.protocol.version00.WebSocket00BinaryFrameSinkChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import io.undertow.websockets.core.protocol.version00.WebSocket00CloseFrameSinkChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00TextFrameSinkChannel;
import io.undertow.websockets.utils.TestUtils;
import java.io.IOException;
import java.util.Collections;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.xnio.ChannelListener;
import org.xnio.channels.ConnectedStreamChannel;

@Ignore
public class WebSocket00ChannelTest {
    @Test
    public void testSendBinary() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.BINARY, 10, WebSocket00BinaryFrameSinkChannel.class);
    }

    @Test
    public void testSendText() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.TEXT, 10, WebSocket00TextFrameSinkChannel.class);
    }

    @Test
    public void testSendClose() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.CLOSE, 0, WebSocket00CloseFrameSinkChannel.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendCloseWithPayload() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.CLOSE, 10, WebSocket00CloseFrameSinkChannel.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendContinuation() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.CONTINUATION, 10, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendPing() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.PING, 10, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendPong() throws IOException {
        WebSocket00ChannelTest.checkSend(WebSocketFrameType.PONG, 10, null);
    }

    private static void checkSend(WebSocketFrameType type, int size, Class<? extends StreamSinkFrameChannel> clazz) throws IOException {
        ConnectedStreamChannel mockChannel = (ConnectedStreamChannel)EasyMock.createMock(ConnectedStreamChannel.class);
        EasyMock.expect((Object)mockChannel.getCloseSetter()).andReturn((Object)new ChannelListener.SimpleSetter()).times(2);
        EasyMock.expect((Object)mockChannel.getReadSetter()).andReturn((Object)new ChannelListener.SimpleSetter());
        EasyMock.expect((Object)mockChannel.getWriteSetter()).andReturn((Object)new ChannelListener.SimpleSetter());
        EasyMock.expect((Object)mockChannel.isOpen()).andReturn((Object)true);
        mockChannel.resumeWrites();
        EasyMock.replay((Object[])new Object[]{mockChannel});
        WebSocket00Channel wsChannel = new WebSocket00Channel(mockChannel, null, "ws://localhost/ws", Collections.emptySet(), false);
        StreamSinkFrameChannel ch = wsChannel.send(type, (long)size);
        Assert.assertTrue((boolean)clazz.isInstance(ch));
        Assert.assertTrue((boolean)ch.isOpen());
        TestUtils.verifyAndReset(mockChannel);
        wsChannel.close();
    }
}

