/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.logging.Logger;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public class FileResource
implements Resource {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.resources.file");
    private final File file;
    private final File resourceManagerRoot;

    public FileResource(File file, File resourceManagerRoot) {
        this.file = file;
        this.resourceManagerRoot = resourceManagerRoot;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    @Override
    public String getLastModifiedString() {
        Date lastModified = this.getLastModified();
        if (lastModified == null) {
            return null;
        }
        return DateUtils.toDateString(lastModified);
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String child : this.file.list()) {
            resources.add(new FileResource(new File(this.file, child), this.resourceManagerRoot));
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(final Sender sender, final HttpServerExchange exchange, final IoCallback callback) {
        class ServerTask
        implements Runnable,
        IoCallback {
            private FileChannel fileChannel;
            private Pooled<ByteBuffer> pooled;

            ServerTask() {
            }

            @Override
            public void run() {
                if (this.fileChannel == null) {
                    try {
                        this.fileChannel = exchange.getConnection().getWorker().getXnio().openFile(FileResource.this.file, FileAccess.READ_ONLY);
                    }
                    catch (FileNotFoundException e) {
                        exchange.setResponseCode(404);
                        callback.onException(exchange, sender, e);
                        return;
                    }
                    catch (IOException e) {
                        exchange.setResponseCode(500);
                        callback.onException(exchange, sender, e);
                        return;
                    }
                    this.pooled = exchange.getConnection().getBufferPool().allocate();
                }
                if (this.pooled != null) {
                    ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
                    try {
                        buffer.clear();
                        int res = this.fileChannel.read(buffer);
                        if (res == -1) {
                            this.pooled.free();
                            callback.onComplete(exchange, sender);
                            return;
                        }
                        buffer.flip();
                        sender.send(buffer, (IoCallback)this);
                    }
                    catch (IOException e) {
                        this.onException(exchange, sender, e);
                    }
                }
            }

            @Override
            public void onComplete(HttpServerExchange exchange2, Sender sender2) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch(this);
                } else {
                    this.run();
                }
            }

            @Override
            public void onException(HttpServerExchange exchange2, Sender sender2, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                if (this.pooled != null) {
                    this.pooled.free();
                    this.pooled = null;
                }
                IoUtils.safeClose((Closeable)this.fileChannel);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setResponseCode(500);
                }
                callback.onException(exchange2, sender2, exception);
            }
        }
        ServerTask serveTask = new ServerTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(serveTask);
        } else {
            serveTask.run();
        }
    }

    @Override
    public Long getContentLength() {
        return this.file.length();
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        for (String possibility : possible) {
            File index = new File(this.file, possibility);
            if (!index.exists()) continue;
            return new FileResource(index, this.resourceManagerRoot);
        }
        return null;
    }

    @Override
    public String getCacheKey() {
        return this.file.toString();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getResourceManagerRoot() {
        return this.resourceManagerRoot;
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

