/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.util.AttachmentKey;
import java.util.TreeMap;

public class PredicatesHandler
implements HttpHandler {
    private volatile Holder[] handlers = new Holder[0];
    private final HttpHandler next;
    private final AttachmentKey<Integer> CURRENT_POSITION = AttachmentKey.create(Integer.class);

    public PredicatesHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        int pos;
        int length = this.handlers.length;
        Integer current = exchange.getAttachment(this.CURRENT_POSITION);
        if (current == null) {
            pos = 0;
            exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
        } else {
            pos = current;
        }
        while (pos < length) {
            Holder handler = this.handlers[pos];
            if (handler.predicate.resolve(exchange)) {
                exchange.putAttachment(this.CURRENT_POSITION, pos + 1);
                handler.handler.handleRequest(exchange);
                return;
            }
            ++pos;
        }
        this.next.handleRequest(exchange);
    }

    public PredicatesHandler addPredicatedHandler(Predicate predicate, HandlerWrapper handlerWrapper) {
        Holder[] old = this.handlers;
        Holder[] handlers = new Holder[old.length + 1];
        System.arraycopy(old, 0, handlers, 0, old.length);
        handlers[old.length] = new Holder(predicate, handlerWrapper.wrap(this));
        this.handlers = handlers;
        return this;
    }

    public PredicatesHandler addPredicatedHandler(PredicatedHandler handler) {
        return this.addPredicatedHandler(handler.getPredicate(), handler.getHandler());
    }

    private static final class Holder {
        final Predicate predicate;
        final HttpHandler handler;

        private Holder(Predicate predicate, HttpHandler handler) {
            this.predicate = predicate;
            this.handler = handler;
        }
    }
}

