/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;

public class FileResourceManager
implements ResourceManager {
    private volatile File base;
    private final long transferMinSize;

    public FileResourceManager(File base, long transferMinSize) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
        this.transferMinSize = transferMinSize;
    }

    public File getBase() {
        return this.base;
    }

    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = p;
        if (p.startsWith("/")) {
            path = p.substring(1);
        }
        try {
            File file = new File(this.base, p);
            if (file.exists()) {
                return new FileResource(file, this, path);
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }
}

