/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;

public class CachedAuthenticatedSessionHandler
implements HttpHandler {
    private static final String ATTRIBUTE_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    private final NotificationReceiver NOTIFICATION_RECEIVER = new SecurityNotificationReceiver();
    private final AuthenticatedSessionManager SESSION_MANAGER = new ServletAuthenticatedSessionManager();
    private final HttpHandler next;
    private final ServletContextImpl servletContext;

    public CachedAuthenticatedSessionHandler(HttpHandler next, ServletContextImpl servletContext) {
        this.next = next;
        this.servletContext = servletContext;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        securityContext.registerNotificationReceiver(this.NOTIFICATION_RECEIVER);
        HttpSessionImpl session = this.servletContext.getSession(exchange, false);
        if (session != null) {
            exchange.putAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY, (Object)this.SESSION_MANAGER);
        }
        this.next.handleRequest(exchange);
    }

    private boolean isCacheable(SecurityNotification notification) {
        return notification.isProgramatic() || "FORM".equals(notification.getMechanism());
    }

    private class ServletAuthenticatedSessionManager
    implements AuthenticatedSessionManager {
        private ServletAuthenticatedSessionManager() {
        }

        public AuthenticatedSessionManager.AuthenticatedSession lookupSession(HttpServerExchange exchange) {
            HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(exchange, false);
            if (session != null) {
                return (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(ATTRIBUTE_NAME);
            }
            return null;
        }
    }

    private class SecurityNotificationReceiver
    implements NotificationReceiver {
        private SecurityNotificationReceiver() {
        }

        public void handleNotification(SecurityNotification notification) {
            SecurityNotification.EventType eventType = notification.getEventType();
            switch (eventType) {
                case AUTHENTICATED: {
                    if (!CachedAuthenticatedSessionHandler.this.isCacheable(notification)) break;
                    HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), true);
                    session.setAttribute(ATTRIBUTE_NAME, new AuthenticatedSessionManager.AuthenticatedSession(notification.getAccount(), notification.getMechanism()));
                    break;
                }
                case LOGGED_OUT: {
                    HttpSessionImpl session = CachedAuthenticatedSessionHandler.this.servletContext.getSession(notification.getExchange(), false);
                    if (session == null) break;
                    session.removeAttribute(ATTRIBUTE_NAME);
                }
            }
        }
    }
}

