/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.Map;
import javax.servlet.SessionCookieConfig;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
SessionConfig {
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private final ServletContextImpl servletContext;
    private String name = "JSESSIONID";
    private String path = "/";
    private String domain;
    private boolean secure;
    private boolean httpOnly;
    private int maxAge;
    private String comment;
    private SessionConfig fallback;

    public SessionCookieConfigImpl(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    public String rewriteUrl(String originalUrl, String sessionid) {
        return originalUrl;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        Cookie cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setComment(this.comment);
        if (this.maxAge > 0) {
            cookie.setMaxAge(Integer.valueOf(this.maxAge));
        }
        exchange.setResponseCookie(cookie);
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setMaxAge(Integer.valueOf(0));
        exchange.setResponseCookie((Cookie)cookie);
    }

    public String findSessionId(HttpServerExchange exchange) {
        Cookie sessionId;
        Map cookies = exchange.getRequestCookies();
        if (cookies != null && (sessionId = (Cookie)cookies.get(this.name)) != null) {
            return sessionId.getValue();
        }
        if (this.fallback != null) {
            return this.fallback.findSessionId(exchange);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.path = path;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.comment = comment;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.httpOnly = httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.secure = secure;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.maxAge = maxAge;
    }

    public SessionConfig getFallback() {
        return this.fallback;
    }

    public void setFallback(SessionConfig fallback) {
        this.fallback = fallback;
    }
}

