/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.IdleTimeoutConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.server.protocol.framed.ShutdownFallbackExecutor;
import io.undertow.util.ReferenceCountedPooled;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public abstract class AbstractFramedChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements ConnectedChannel {
    private final int maxQueuedBuffers;
    private final StreamConnection channel;
    private final IdleTimeoutConduit idleTimeoutConduit;
    private final ChannelListener.SimpleSetter<C> closeSetter;
    private final ChannelListener.SimpleSetter<C> receiveSetter;
    private final ByteBufferPool bufferPool;
    private final FramePriority<C, R, S> framePriority;
    private final List<S> pendingFrames = new LinkedList<S>();
    private final Deque<S> heldFrames = new ArrayDeque<S>();
    private final Deque<S> newFrames = new LinkedBlockingDeque<S>();
    private volatile long frameDataRemaining;
    private volatile R receiver;
    private volatile boolean receivesSuspendedByUser = true;
    private volatile boolean receivesSuspendedTooManyQueuedMessages = false;
    private volatile boolean receivesSuspendedTooManyBuffers = false;
    private volatile int readsBroken = 0;
    private volatile int writesBroken = 0;
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> readsBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "readsBroken");
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> writesBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "writesBroken");
    private volatile ReferenceCountedPooled readData = null;
    private final List<ChannelListener<C>> closeTasks = new CopyOnWriteArrayList<ChannelListener<C>>();
    private volatile boolean flushingSenders = false;
    private boolean partialRead = false;
    private volatile int outstandingBuffers;
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> outstandingBuffersUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "outstandingBuffers");
    private final LinkedBlockingDeque<Runnable> taskRunQueue = new LinkedBlockingDeque();
    private final Runnable taskRunQueueRunnable = new Runnable(){

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = AbstractFramedChannel.this.taskRunQueue.poll()) != null) {
                runnable.run();
            }
        }
    };
    private final OptionMap settings;
    private volatile boolean requireExplicitFlush = false;
    private volatile boolean readChannelDone = false;
    private final int queuedFrameHighWaterMark;
    private final int queuedFrameLowWaterMark;
    private final ReferenceCountedPooled.FreeNotifier freeNotifier = new ReferenceCountedPooled.FreeNotifier(){

        @Override
        public void freed() {
            int res = outstandingBuffersUpdater.decrementAndGet(AbstractFramedChannel.this);
            if (res == AbstractFramedChannel.this.maxQueuedBuffers / 2 && AbstractFramedChannel.this.receivesSuspendedTooManyBuffers) {
                AbstractFramedChannel.this.getIoThread().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AbstractFramedChannel abstractFramedChannel = AbstractFramedChannel.this;
                        synchronized (abstractFramedChannel) {
                            if (UndertowLogger.REQUEST_IO_LOGGER.isTraceEnabled()) {
                                UndertowLogger.REQUEST_IO_LOGGER.tracef("Resuming reads on %s as buffers have been consumed", AbstractFramedChannel.this);
                            }
                            new UpdateResumeState(null, false, null).run();
                        }
                    }
                });
            }
        }
    };
    private static final ChannelListener<AbstractFramedChannel> DRAIN_LISTENER = new ChannelListener<AbstractFramedChannel>(){

        public void handleEvent(AbstractFramedChannel channel) {
            try {
                Object stream = channel.receive();
                if (stream != null) {
                    UndertowLogger.REQUEST_IO_LOGGER.debugf("Draining channel %s as no receive listener has been set", stream);
                    ((AbstractFramedStreamSourceChannel)stream).getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, null, null));
                    ((AbstractFramedStreamSourceChannel)stream).wakeupReads();
                }
            }
            catch (IOException | Error | RuntimeException e) {
                IoUtils.safeClose((Closeable)((Object)channel));
            }
        }
    };

    protected AbstractFramedChannel(StreamConnection connectedStreamChannel, ByteBufferPool bufferPool, FramePriority<C, R, S> framePriority, PooledByteBuffer readData, OptionMap settings) {
        this.framePriority = framePriority;
        this.maxQueuedBuffers = settings.get(UndertowOptions.MAX_QUEUED_READ_BUFFERS, 16);
        this.settings = settings;
        if (readData != null) {
            if (readData.getBuffer().hasRemaining()) {
                this.readData = new ReferenceCountedPooled(readData, 1);
            } else {
                readData.close();
            }
        }
        if (bufferPool == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("bufferPool");
        }
        if (connectedStreamChannel == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("connectedStreamChannel");
        }
        IdleTimeoutConduit idle = this.createIdleTimeoutChannel(connectedStreamChannel);
        connectedStreamChannel.getSourceChannel().setConduit((StreamSourceConduit)idle);
        connectedStreamChannel.getSinkChannel().setConduit((StreamSinkConduit)idle);
        this.idleTimeoutConduit = idle;
        this.channel = connectedStreamChannel;
        this.bufferPool = bufferPool;
        this.closeSetter = new ChannelListener.SimpleSetter();
        this.receiveSetter = new ChannelListener.SimpleSetter();
        this.channel.getSourceChannel().getReadSetter().set(null);
        this.channel.getSourceChannel().suspendReads();
        this.channel.getSourceChannel().getReadSetter().set((ChannelListener)new FrameReadListener());
        connectedStreamChannel.getSinkChannel().getWriteSetter().set((ChannelListener)new FrameWriteListener());
        FrameCloseListener closeListener = new FrameCloseListener();
        connectedStreamChannel.getSinkChannel().getCloseSetter().set((ChannelListener)closeListener);
        connectedStreamChannel.getSourceChannel().getCloseSetter().set((ChannelListener)closeListener);
        this.queuedFrameHighWaterMark = settings.get(UndertowOptions.QUEUED_FRAMES_HIGH_WATER_MARK, 50);
        this.queuedFrameLowWaterMark = settings.get(UndertowOptions.QUEUED_FRAMES_LOW_WATER_MARK, 10);
    }

    protected IdleTimeoutConduit createIdleTimeoutChannel(StreamConnection connectedStreamChannel) {
        return new IdleTimeoutConduit(connectedStreamChannel);
    }

    void runInIoThread(Runnable task) {
        this.taskRunQueue.add(task);
        try {
            this.getIoThread().execute(this.taskRunQueueRunnable);
        }
        catch (RejectedExecutionException e) {
            ShutdownFallbackExecutor.execute(this.taskRunQueueRunnable);
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IOException {
        return (T)this.channel.setOption(option, value);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    public InetSocketAddress getSourceAddress() {
        return this.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.getLocalAddress(InetSocketAddress.class);
    }

    public synchronized R receive() throws IOException {
        ReferenceCountedPooled pooled = this.readData;
        if (this.readChannelDone && this.receiver == null) {
            if (pooled != null) {
                pooled.close();
                this.readData = null;
            }
            this.channel.getSourceChannel().suspendReads();
            this.channel.getSourceChannel().shutdownReads();
            return null;
        }
        this.partialRead = false;
        boolean requiresReinvoke = false;
        int reinvokeDataRemaining = 0;
        boolean hasData = false;
        if (pooled == null) {
            pooled = this.allocateReferenceCountedBuffer();
            if (pooled == null) {
                return null;
            }
        } else if (pooled.isFreed()) {
            if (!pooled.tryUnfree() && (pooled = this.allocateReferenceCountedBuffer()) == null) {
                return null;
            }
            pooled.getBuffer().clear();
        } else {
            hasData = pooled.getBuffer().hasRemaining();
            pooled.getBuffer().compact();
        }
        boolean forceFree = false;
        int read = 0;
        try {
            read = this.channel.getSourceChannel().read(pooled.getBuffer());
            if (read == 0 && !hasData) {
                forceFree = true;
                R r = null;
                return r;
            }
            if (read == -1 && !hasData) {
                forceFree = true;
                this.readChannelDone = true;
                this.lastDataRead();
                R r = null;
                return r;
            }
            if (this.isLastFrameReceived() && this.frameDataRemaining == 0L) {
                forceFree = true;
                this.markReadsBroken(new ClosedChannelException());
            }
            pooled.getBuffer().flip();
            if (read == -1) {
                requiresReinvoke = true;
                reinvokeDataRemaining = pooled.getBuffer().remaining();
            }
            if (this.frameDataRemaining > 0L) {
                if (this.frameDataRemaining >= (long)pooled.getBuffer().remaining()) {
                    PooledByteBuffer frameData;
                    this.frameDataRemaining -= (long)pooled.getBuffer().remaining();
                    if (this.receiver != null) {
                        frameData = pooled.createView();
                        ((AbstractFramedStreamSourceChannel)this.receiver).dataReady(null, frameData);
                    } else {
                        pooled.close();
                        this.readData = null;
                    }
                    if (this.frameDataRemaining == 0L) {
                        this.receiver = null;
                    }
                    frameData = null;
                    return (R)frameData;
                }
                PooledByteBuffer frameData = pooled.createView((int)this.frameDataRemaining);
                this.frameDataRemaining = 0L;
                if (this.receiver != null) {
                    ((AbstractFramedStreamSourceChannel)this.receiver).dataReady(null, frameData);
                } else {
                    frameData.close();
                }
                this.receiver = null;
                frameData = null;
                return (R)frameData;
            }
            FrameHeaderData data = this.parseFrame(pooled.getBuffer());
            if (data != null) {
                PooledByteBuffer frameData;
                if (data.getFrameLength() >= (long)pooled.getBuffer().remaining()) {
                    this.frameDataRemaining = data.getFrameLength() - (long)pooled.getBuffer().remaining();
                    frameData = pooled.createView();
                    pooled.getBuffer().position(pooled.getBuffer().limit());
                } else {
                    frameData = pooled.createView((int)data.getFrameLength());
                }
                AbstractFramedStreamSourceChannel<?, ?, ?> existing = data.getExistingChannel();
                if (existing != null) {
                    if (data.getFrameLength() > (long)frameData.getBuffer().remaining()) {
                        this.receiver = existing;
                    }
                    existing.dataReady(data, frameData);
                    if (this.isLastFrameReceived()) {
                        this.handleLastFrame(existing);
                    }
                    R r = null;
                    return r;
                }
                boolean moreData = data.getFrameLength() > (long)frameData.getBuffer().remaining();
                R newChannel = this.createChannel(data, frameData);
                if (newChannel != null) {
                    if (moreData) {
                        this.receiver = newChannel;
                    }
                    if (this.isLastFrameReceived()) {
                        this.handleLastFrame((AbstractFramedStreamSourceChannel)newChannel);
                    }
                } else {
                    frameData.close();
                }
                R r = newChannel;
                return r;
            }
            this.partialRead = true;
            R r = null;
            return r;
        }
        catch (IOException | Error | RuntimeException e) {
            this.markReadsBroken(e);
            forceFree = true;
            throw e;
        }
        finally {
            if (this.readData != null && (!pooled.getBuffer().hasRemaining() || forceFree)) {
                if (pooled.getBuffer().capacity() < 1024 || forceFree) {
                    this.readData = null;
                }
                pooled.close();
            }
            if (requiresReinvoke) {
                if (pooled != null && !pooled.isFreed() && pooled.getBuffer().remaining() == reinvokeDataRemaining) {
                    pooled.close();
                    this.readData = null;
                    UndertowLogger.REQUEST_IO_LOGGER.debugf("Partial message read before connection close %s", this);
                }
                this.channel.getSourceChannel().wakeupReads();
            }
        }
    }

    private void handleLastFrame(AbstractFramedStreamSourceChannel newChannel) {
        HashSet<AbstractFramedStreamSourceChannel<C, R, S>> receivers = new HashSet<AbstractFramedStreamSourceChannel<C, R, S>>(this.getReceivers());
        for (AbstractFramedStreamSourceChannel abstractFramedStreamSourceChannel : receivers) {
            if (abstractFramedStreamSourceChannel == newChannel) continue;
            abstractFramedStreamSourceChannel.markStreamBroken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceCountedPooled allocateReferenceCountedBuffer() {
        if (this.maxQueuedBuffers > 0) {
            int expect;
            do {
                if ((expect = outstandingBuffersUpdater.get(this)) < this.maxQueuedBuffers && !this.receivesSuspendedTooManyBuffers) continue;
                AbstractFramedChannel abstractFramedChannel = this;
                synchronized (abstractFramedChannel) {
                    if (this.receivesSuspendedTooManyBuffers) {
                        return null;
                    }
                    expect = outstandingBuffersUpdater.get(this);
                    if (expect >= this.maxQueuedBuffers) {
                        if (UndertowLogger.REQUEST_IO_LOGGER.isTraceEnabled()) {
                            UndertowLogger.REQUEST_IO_LOGGER.tracef("Suspending reads on %s due to too many outstanding buffers", this);
                        }
                        this.receivesSuspendedTooManyBuffers = true;
                        this.getIoThread().execute((Runnable)new UpdateResumeState(null, true, null));
                        return null;
                    }
                }
            } while (!outstandingBuffersUpdater.compareAndSet(this, expect, expect + 1));
        }
        PooledByteBuffer buf = this.bufferPool.allocate();
        this.readData = new ReferenceCountedPooled(buf, 1, this.maxQueuedBuffers > 0 ? this.freeNotifier : null);
        return this.readData;
    }

    protected void lastDataRead() {
    }

    protected abstract R createChannel(FrameHeaderData var1, PooledByteBuffer var2) throws IOException;

    protected abstract FrameHeaderData parseFrame(ByteBuffer var1) throws IOException;

    protected synchronized void recalculateHeldFrames() throws IOException {
        if (!this.heldFrames.isEmpty()) {
            this.framePriority.frameAdded(null, this.pendingFrames, this.heldFrames);
            this.flushSenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void flushSenders() {
        ListIterator<S> it;
        boolean finalFrame;
        int toSend;
        block26: {
            AbstractFramedStreamSinkChannel sender;
            AbstractFramedStreamSinkChannel frame;
            if (this.flushingSenders) {
                throw UndertowMessages.MESSAGES.recursiveCallToFlushingSenders();
            }
            this.flushingSenders = true;
            toSend = 0;
            while ((frame = (AbstractFramedStreamSinkChannel)this.newFrames.poll()) != null) {
                frame.preWrite();
                if (this.framePriority.insertFrame(frame, this.pendingFrames)) {
                    if (this.heldFrames.isEmpty()) continue;
                    this.framePriority.frameAdded(frame, this.pendingFrames, this.heldFrames);
                    continue;
                }
                this.heldFrames.add(frame);
            }
            finalFrame = false;
            it = this.pendingFrames.listIterator();
            while (it.hasNext() && (sender = (AbstractFramedStreamSinkChannel)it.next()).isReadyForFlush()) {
                ++toSend;
                if (!sender.isLastFrame()) continue;
                finalFrame = true;
            }
            if (toSend != 0) break block26;
            try {
                if (this.channel.getSinkChannel().flush()) {
                    this.channel.getSinkChannel().suspendWrites();
                }
            }
            catch (Throwable e) {
                IoUtils.safeClose((Closeable)this.channel);
                this.markWritesBroken(e);
            }
            this.flushingSenders = false;
            if (!this.newFrames.isEmpty()) {
                this.runInIoThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFramedChannel.this.flushSenders();
                    }
                });
            }
            return;
        }
        try {
            Buffer[] data = new ByteBuffer[toSend * 3];
            it = this.pendingFrames.listIterator();
            try {
                long res;
                for (int j = 0; j < toSend; ++j) {
                    AbstractFramedStreamSinkChannel next = (AbstractFramedStreamSinkChannel)it.next();
                    SendFrameHeader frameHeader = next.getFrameHeader();
                    PooledByteBuffer frameHeaderByteBuffer = frameHeader.getByteBuffer();
                    ByteBuffer frameTrailerBuffer = frameHeader.getTrailer();
                    data[j * 3] = frameHeaderByteBuffer != null ? frameHeaderByteBuffer.getBuffer() : Buffers.EMPTY_BYTE_BUFFER;
                    data[j * 3 + 1] = next.getBuffer() == null ? Buffers.EMPTY_BYTE_BUFFER : next.getBuffer();
                    data[j * 3 + 2] = frameTrailerBuffer != null ? frameTrailerBuffer : Buffers.EMPTY_BYTE_BUFFER;
                }
                long toWrite = Buffers.remaining((Buffer[])data);
                while ((res = this.channel.getSinkChannel().write((ByteBuffer[])data)) > 0L && (toWrite -= res) > 0L) {
                }
                for (int max = toSend; max > 0; --max) {
                    AbstractFramedStreamSinkChannel sinkChannel = (AbstractFramedStreamSinkChannel)this.pendingFrames.get(0);
                    PooledByteBuffer frameHeaderByteBuffer = sinkChannel.getFrameHeader().getByteBuffer();
                    ByteBuffer frameTrailerBuffer = sinkChannel.getFrameHeader().getTrailer();
                    if (frameHeaderByteBuffer != null && frameHeaderByteBuffer.getBuffer().hasRemaining() || sinkChannel.getBuffer() != null && sinkChannel.getBuffer().hasRemaining() || frameTrailerBuffer != null && frameTrailerBuffer.hasRemaining()) break;
                    sinkChannel.flushComplete();
                    this.pendingFrames.remove(sinkChannel);
                }
                if (!this.pendingFrames.isEmpty() || !this.channel.getSinkChannel().flush()) {
                    this.channel.getSinkChannel().resumeWrites();
                } else {
                    this.channel.getSinkChannel().suspendWrites();
                }
                if (this.pendingFrames.isEmpty() && finalFrame) {
                    this.channel.getSinkChannel().shutdownWrites();
                    if (!this.channel.getSinkChannel().flush()) {
                        this.channel.getSinkChannel().setWriteListener(ChannelListeners.flushingChannelListener(null, null));
                        this.channel.getSinkChannel().resumeWrites();
                    }
                } else if (this.pendingFrames.size() > this.queuedFrameHighWaterMark) {
                    new UpdateResumeState(null, null, true).run();
                } else if (this.receivesSuspendedTooManyQueuedMessages && this.pendingFrames.size() < this.queuedFrameLowWaterMark) {
                    new UpdateResumeState(null, null, false).run();
                }
            }
            catch (IOException | Error | RuntimeException e) {
                IoUtils.safeClose((Closeable)this.channel);
                this.markWritesBroken(e);
            }
            this.flushingSenders = false;
        }
        catch (Throwable throwable) {
            this.flushingSenders = false;
            if (!this.newFrames.isEmpty()) {
                this.runInIoThread(new /* invalid duplicate definition of identical inner class */);
            }
            throw throwable;
        }
        if (!this.newFrames.isEmpty()) {
            this.runInIoThread(new /* invalid duplicate definition of identical inner class */);
        }
    }

    void awaitWritable() throws IOException {
        this.channel.getSinkChannel().awaitWritable();
    }

    void awaitWritable(long time, TimeUnit unit) throws IOException {
        this.channel.getSinkChannel().awaitWritable(time, unit);
    }

    protected void queueFrame(S channel) throws IOException {
        assert (!this.newFrames.contains(channel));
        if (this.isWritesBroken() || !this.channel.getSinkChannel().isOpen() || ((AbstractFramedStreamSinkChannel)channel).isBroken() || !((AbstractFramedStreamSinkChannel)channel).isOpen()) {
            IoUtils.safeClose(channel);
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.newFrames.add(channel);
        if (!this.requireExplicitFlush || ((AbstractFramedStreamSinkChannel)channel).isBufferFull()) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.flushingSenders) {
            if (this.channel.getIoThread() == Thread.currentThread()) {
                this.flushSenders();
            } else {
                this.runInIoThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFramedChannel.this.flushSenders();
                    }
                });
            }
        }
    }

    protected abstract boolean isLastFrameReceived();

    protected abstract boolean isLastFrameSent();

    protected abstract void handleBrokenSourceChannel(Throwable var1);

    protected abstract void handleBrokenSinkChannel(Throwable var1);

    public ChannelListener.Setter<C> getReceiveSetter() {
        return this.receiveSetter;
    }

    public synchronized void suspendReceives() {
        this.receivesSuspendedByUser = true;
        this.getIoThread().execute((Runnable)new UpdateResumeState(true, null, null));
    }

    public synchronized void resumeReceives() {
        this.receivesSuspendedByUser = false;
        this.getIoThread().execute((Runnable)new UpdateResumeState(false, null, null));
    }

    private void doResume() {
        ReferenceCountedPooled localReadData = this.readData;
        if (localReadData != null && !localReadData.isFreed()) {
            this.channel.getSourceChannel().wakeupReads();
        } else {
            this.channel.getSourceChannel().resumeReads();
        }
    }

    public boolean isReceivesResumed() {
        return !this.receivesSuspendedByUser;
    }

    public void close() throws IOException {
        if (UndertowLogger.REQUEST_IO_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_IO_LOGGER.tracef(new ClosedChannelException(), "Channel %s is being closed", this);
        }
        IoUtils.safeClose((Closeable)this.channel);
        ReferenceCountedPooled localReadData = this.readData;
        if (localReadData != null) {
            localReadData.close();
            this.readData = null;
        }
        this.closeSubChannels();
    }

    public ChannelListener.Setter<? extends AbstractFramedChannel> getCloseSetter() {
        return this.closeSetter;
    }

    protected void markReadsBroken(Throwable cause) {
        if (readsBrokenUpdater.compareAndSet(this, 0, 1)) {
            if (UndertowLogger.REQUEST_IO_LOGGER.isDebugEnabled()) {
                UndertowLogger.REQUEST_IO_LOGGER.debugf(new ClosedChannelException(), "Marking reads broken on channel %s", this);
            }
            if (this.receiver != null) {
                ((AbstractFramedStreamSourceChannel)this.receiver).markStreamBroken();
            }
            for (AbstractFramedStreamSourceChannel<C, R, S> r : new ArrayList<AbstractFramedStreamSourceChannel<C, R, S>>(this.getReceivers())) {
                r.markStreamBroken();
            }
            this.handleBrokenSourceChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            this.closeSubChannels();
        }
    }

    protected abstract void closeSubChannels();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markWritesBroken(Throwable cause) {
        if (writesBrokenUpdater.compareAndSet(this, 0, 1)) {
            if (UndertowLogger.REQUEST_IO_LOGGER.isDebugEnabled()) {
                UndertowLogger.REQUEST_IO_LOGGER.debugf(new ClosedChannelException(), "Marking writes broken on channel %s", this);
            }
            this.handleBrokenSinkChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSinkChannel());
            AbstractFramedChannel abstractFramedChannel = this;
            synchronized (abstractFramedChannel) {
                for (AbstractFramedStreamSinkChannel channel : this.pendingFrames) {
                    channel.markBroken();
                }
                this.pendingFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.newFrames) {
                    channel.markBroken();
                }
                this.newFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.heldFrames) {
                    channel.markBroken();
                }
                this.heldFrames.clear();
            }
        }
    }

    protected boolean isWritesBroken() {
        return writesBrokenUpdater.get(this) != 0;
    }

    protected boolean isReadsBroken() {
        return readsBrokenUpdater.get(this) != 0;
    }

    void resumeWrites() {
        this.channel.getSinkChannel().resumeWrites();
    }

    void suspendWrites() {
        this.channel.getSinkChannel().suspendWrites();
    }

    void wakeupWrites() {
        this.channel.getSinkChannel().wakeupWrites();
    }

    StreamSourceChannel getSourceChannel() {
        return this.channel.getSourceChannel();
    }

    void notifyFrameReadComplete(AbstractFramedStreamSourceChannel<C, R, S> channel) {
    }

    private boolean isReadsSuspended() {
        return this.receivesSuspendedByUser || this.receivesSuspendedTooManyBuffers || this.receivesSuspendedTooManyQueuedMessages;
    }

    protected abstract Collection<AbstractFramedStreamSourceChannel<C, R, S>> getReceivers();

    public void setIdleTimeout(long timeout) {
        this.idleTimeoutConduit.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this.idleTimeoutConduit.getIdleTimeout();
    }

    protected FramePriority<C, R, S> getFramePriority() {
        return this.framePriority;
    }

    public void addCloseTask(ChannelListener<C> task) {
        this.closeTasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append(this.getClass().getSimpleName()).append(" peer ").append(this.channel.getPeerAddress()).append(" local ").append(this.channel.getLocalAddress()).append("[ ");
        AbstractFramedChannel abstractFramedChannel = this;
        synchronized (abstractFramedChannel) {
            stringBuilder.append(this.receiver == null ? "No Receiver" : this.receiver.toString()).append(" ").append(this.pendingFrames.toString()).append(" -- ").append(this.heldFrames.toString()).append(" -- ").append(this.newFrames.toString());
        }
        return stringBuilder.toString();
    }

    protected StreamConnection getUnderlyingConnection() {
        return this.channel;
    }

    protected ChannelExceptionHandler<SuspendableWriteChannel> writeExceptionHandler() {
        return new ChannelExceptionHandler<SuspendableWriteChannel>(){

            public void handleException(SuspendableWriteChannel channel, IOException exception) {
                AbstractFramedChannel.this.markWritesBroken(exception);
            }
        };
    }

    public boolean isRequireExplicitFlush() {
        return this.requireExplicitFlush;
    }

    public void setRequireExplicitFlush(boolean requireExplicitFlush) {
        this.requireExplicitFlush = requireExplicitFlush;
    }

    protected OptionMap getSettings() {
        return this.settings;
    }

    private class UpdateResumeState
    implements Runnable {
        private final Boolean user;
        private final Boolean buffers;
        private final Boolean frames;

        private UpdateResumeState(Boolean user, Boolean buffers, Boolean frames) {
            this.user = user;
            this.buffers = buffers;
            this.frames = frames;
        }

        @Override
        public void run() {
            if (this.user != null) {
                AbstractFramedChannel.this.receivesSuspendedByUser = this.user;
            }
            if (this.buffers != null) {
                AbstractFramedChannel.this.receivesSuspendedTooManyBuffers = this.buffers;
            }
            if (this.frames != null) {
                AbstractFramedChannel.this.receivesSuspendedTooManyQueuedMessages = this.frames;
            }
            if (AbstractFramedChannel.this.receivesSuspendedByUser || AbstractFramedChannel.this.receivesSuspendedTooManyQueuedMessages || AbstractFramedChannel.this.receivesSuspendedTooManyBuffers) {
                AbstractFramedChannel.this.channel.getSourceChannel().suspendReads();
            } else {
                AbstractFramedChannel.this.doResume();
            }
        }
    }

    private class FrameCloseListener
    implements ChannelListener<CloseableChannel> {
        private boolean sinkClosed;
        private boolean sourceClosed;

        private FrameCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(final CloseableChannel c) {
            if (Thread.currentThread() != c.getIoThread() && !c.getWorker().isShutdown()) {
                AbstractFramedChannel.this.runInIoThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListeners.invokeChannelListener((Channel)c, (ChannelListener)FrameCloseListener.this);
                    }
                });
                return;
            }
            if (c instanceof StreamSinkChannel) {
                this.sinkClosed = true;
            } else if (c instanceof StreamSourceChannel) {
                this.sourceClosed = true;
            }
            final ReferenceCountedPooled localReadData = AbstractFramedChannel.this.readData;
            if (!this.sourceClosed || !this.sinkClosed) {
                return;
            }
            if (localReadData != null && !localReadData.isFreed()) {
                AbstractFramedChannel.this.runInIoThread(new Runnable(){

                    @Override
                    public void run() {
                        while (localReadData != null && !localReadData.isFreed()) {
                            int rem = localReadData.getBuffer().remaining();
                            ChannelListener<AbstractFramedChannel> listener = AbstractFramedChannel.this.receiveSetter.get();
                            if (listener == null) {
                                listener = DRAIN_LISTENER;
                            }
                            ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedChannel.this), listener);
                            if (AbstractFramedChannel.this.isOpen() && (localReadData == null || rem != localReadData.getBuffer().remaining())) continue;
                            break;
                        }
                        FrameCloseListener.this.handleEvent(c);
                    }
                });
                return;
            }
            Object receiver = AbstractFramedChannel.this.receiver;
            try {
                ArrayList receivers;
                ArrayList heldFrames;
                ArrayList newFrames;
                ArrayList pendingFrames;
                if (receiver != null && ((AbstractFramedStreamSourceChannel)receiver).isOpen() && ((AbstractFramedStreamSourceChannel)receiver).isReadResumed()) {
                    ChannelListeners.invokeChannelListener(receiver, (ChannelListener)((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get());
                }
                Iterator iterator = AbstractFramedChannel.this;
                synchronized (iterator) {
                    pendingFrames = new ArrayList(AbstractFramedChannel.this.pendingFrames);
                    newFrames = new ArrayList(AbstractFramedChannel.this.newFrames);
                    heldFrames = new ArrayList(AbstractFramedChannel.this.heldFrames);
                    receivers = new ArrayList(AbstractFramedChannel.this.getReceivers());
                }
                for (AbstractFramedStreamSinkChannel abstractFramedStreamSinkChannel : pendingFrames) {
                    abstractFramedStreamSinkChannel.markBroken();
                }
                for (AbstractFramedStreamSinkChannel abstractFramedStreamSinkChannel : newFrames) {
                    abstractFramedStreamSinkChannel.markBroken();
                }
                for (AbstractFramedStreamSinkChannel abstractFramedStreamSinkChannel : heldFrames) {
                    abstractFramedStreamSinkChannel.markBroken();
                }
                for (AbstractFramedStreamSourceChannel abstractFramedStreamSourceChannel : receivers) {
                    IoUtils.safeClose((Closeable)((Object)abstractFramedStreamSourceChannel));
                }
            }
            finally {
                try {
                    for (ChannelListener task : AbstractFramedChannel.this.closeTasks) {
                        ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedChannel.this), task);
                    }
                }
                finally {
                    AbstractFramedChannel abstractFramedChannel = AbstractFramedChannel.this;
                    synchronized (abstractFramedChannel) {
                        AbstractFramedChannel.this.closeSubChannels();
                        if (localReadData != null) {
                            localReadData.close();
                            AbstractFramedChannel.this.readData = null;
                        }
                    }
                    ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedChannel.this), (ChannelListener)AbstractFramedChannel.this.closeSetter.get());
                }
            }
        }
    }

    private class FrameWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private FrameWriteListener() {
        }

        public void handleEvent(StreamSinkChannel channel) {
            AbstractFramedChannel.this.flushSenders();
        }
    }

    private final class FrameReadListener
    implements ChannelListener<StreamSourceChannel> {
        private FrameReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(final StreamSourceChannel channel) {
            boolean partialRead;
            Runnable runnable;
            while ((runnable = AbstractFramedChannel.this.taskRunQueue.poll()) != null) {
                runnable.run();
            }
            Object receiver = AbstractFramedChannel.this.receiver;
            if ((AbstractFramedChannel.this.readChannelDone || AbstractFramedChannel.this.isReadsSuspended()) && receiver == null) {
                channel.suspendReads();
                return;
            }
            ChannelListener<AbstractFramedChannel> listener = AbstractFramedChannel.this.receiveSetter.get();
            if (listener == null) {
                listener = DRAIN_LISTENER;
            }
            UndertowLogger.REQUEST_IO_LOGGER.tracef("Invoking receive listener: %s - receiver: %s", listener, receiver);
            ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedChannel.this), listener);
            AbstractFramedChannel abstractFramedChannel = AbstractFramedChannel.this;
            synchronized (abstractFramedChannel) {
                partialRead = AbstractFramedChannel.this.partialRead;
            }
            ReferenceCountedPooled localReadData = AbstractFramedChannel.this.readData;
            if (localReadData != null && !localReadData.isFreed() && channel.isOpen() && !partialRead) {
                try {
                    AbstractFramedChannel.this.runInIoThread(new Runnable(){

                        @Override
                        public void run() {
                            ChannelListeners.invokeChannelListener((Channel)channel, (ChannelListener)FrameReadListener.this);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    IoUtils.safeClose((Closeable)((Object)AbstractFramedChannel.this));
                }
            }
            AbstractFramedChannel abstractFramedChannel2 = AbstractFramedChannel.this;
            synchronized (abstractFramedChannel2) {
                AbstractFramedChannel.this.partialRead = false;
            }
        }
    }
}

