/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

public class ServletSessionIdAttribute
implements ExchangeAttribute {
    public static final String SESSION_ID_SHORT = "%S";
    public static final String SESSION_ID = "%{SESSION_ID}";
    public static final ServletSessionIdAttribute INSTANCE = new ServletSessionIdAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        HttpSession session;
        ServletRequest req;
        ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest && (session = ((HttpServletRequest)req).getSession(false)) != null) {
            return session.getId();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Session ID", newValue);
    }

    public String toString() {
        return SESSION_ID;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Session ID attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ServletSessionIdAttribute.SESSION_ID) || token.equals(ServletSessionIdAttribute.SESSION_ID_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

