/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import jakarta.websocket.server.HandshakeRequest;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ExchangeHandshakeRequest
implements HandshakeRequest {
    private final WebSocketHttpExchange exchange;
    private Map<String, List<String>> headers;

    public ExchangeHandshakeRequest(WebSocketHttpExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = this.exchange.getRequestHeaders();
        }
        return this.headers;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.exchange.getUserPrincipal();
    }

    @Override
    public URI getRequestURI() {
        return URI.create(this.exchange.getRequestURI());
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.exchange.isUserInRole(role);
    }

    @Override
    public Object getHttpSession() {
        return this.exchange.getSession();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        HashMap requestParameters = new HashMap();
        for (Map.Entry<String, List<String>> e : this.exchange.getRequestParameters().entrySet()) {
            ArrayList list = (ArrayList)requestParameters.get(e.getKey());
            if (list == null) {
                list = new ArrayList();
                requestParameters.put(e.getKey(), list);
            }
            list.addAll(e.getValue());
        }
        Map<String, String> pathParms = this.exchange.getAttachment(HandshakeUtil.PATH_PARAMS);
        if (pathParms != null) {
            for (Map.Entry<String, String> e : pathParms.entrySet()) {
                ArrayList<String> list = (ArrayList<String>)requestParameters.get(e.getKey());
                if (list == null) {
                    list = new ArrayList<String>();
                    requestParameters.put(e.getKey(), list);
                }
                list.add(e.getValue());
            }
        }
        return Collections.unmodifiableMap(requestParameters);
    }

    @Override
    public String getQueryString() {
        return this.exchange.getQueryString();
    }
}

