/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.conduits.PipelingBufferingStreamSinkConduit;
import io.undertow.io.IoCallback;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.ConnectedStreamChannel;

public class HttpContinue {
    public static final String CONTINUE = "100-continue";
    private static final ByteBuffer BUFFER = ByteBuffer.wrap("HTTP/1.1 100 Continue\r\nConnection: keep-alive\r\n\r\n".getBytes());

    public static boolean requiresContinueResponse(HttpServerExchange exchange) {
        if (!exchange.isHttp11()) {
            return false;
        }
        if (exchange.getConnection().getExtraBytes() != null) {
            return false;
        }
        List<String> expect = exchange.getRequestHeaders().get(Headers.EXPECT);
        if (expect != null) {
            for (String header : expect) {
                if (!header.toLowerCase().equals(CONTINUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void sendContinueResponse(final HttpServerExchange exchange, final IoCallback callback) {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
        }
        final PipelingBufferingStreamSinkConduit pipelingbuffer = exchange.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        ConnectedStreamChannel channel = exchange.getConnection().getChannel();
        if (pipelingbuffer != null) {
            try {
                if (!pipelingbuffer.flushPipelinedData()) {
                    channel.getWriteSetter().set((ChannelListener<? extends ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

                        @Override
                        public void handleEvent(ConnectedStreamChannel channel) {
                            try {
                                if (pipelingbuffer.flushPipelinedData()) {
                                    channel.suspendWrites();
                                    HttpContinue.internalSendContinueResponse(exchange, channel, callback);
                                }
                            }
                            catch (IOException e) {
                                callback.onException(exchange, null, e);
                                IoUtils.safeClose((Closeable)channel);
                                return;
                            }
                        }
                    });
                    channel.resumeWrites();
                }
            }
            catch (IOException e) {
                callback.onException(exchange, null, e);
                return;
            }
        }
        HttpContinue.internalSendContinueResponse(exchange, channel, callback);
    }

    public static void sendContinueResponse(HttpServerExchange exchange) throws IOException {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
        }
        PipelingBufferingStreamSinkConduit pipelingBuffer = exchange.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        ConnectedStreamChannel channel = exchange.getConnection().getChannel();
        if (pipelingBuffer != null && !pipelingBuffer.flushPipelinedData()) {
            channel.awaitWritable();
        }
        ByteBuffer buf = BUFFER.duplicate();
        channel.write(buf);
        while (buf.hasRemaining()) {
            channel.awaitWritable();
            channel.write(buf);
        }
        while (!channel.flush()) {
            channel.awaitWritable();
        }
    }

    public static void rejectExchange(HttpServerExchange exchange) {
        exchange.setResponseCode(417);
        exchange.endExchange();
    }

    private static void internalSendContinueResponse(final HttpServerExchange exchange, ConnectedStreamChannel channel, final IoCallback callback) {
        final ByteBuffer buf = BUFFER.duplicate();
        int res = 0;
        do {
            try {
                res = channel.write(buf);
                if (res != 0) continue;
                channel.getWriteSetter().set((ChannelListener<? extends ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

                    @Override
                    public void handleEvent(ConnectedStreamChannel channel) {
                        int res = 0;
                        do {
                            try {
                                res = channel.write(buf);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                callback.onException(exchange, null, e);
                                return;
                            }
                        } while (buf.hasRemaining());
                        channel.suspendWrites();
                        HttpContinue.flushChannel(exchange, channel, callback);
                    }
                });
                channel.resumeWrites();
            }
            catch (IOException e) {
                callback.onException(exchange, null, e);
                return;
            }
        } while (buf.hasRemaining());
        HttpContinue.flushChannel(exchange, channel, callback);
    }

    private static void flushChannel(final HttpServerExchange exchange, ConnectedStreamChannel channel, final IoCallback callback) {
        try {
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<ConnectedStreamChannel>(){

                    @Override
                    public void handleEvent(ConnectedStreamChannel channel) {
                        callback.onComplete(exchange, null);
                        channel.suspendWrites();
                    }
                }, new ChannelExceptionHandler<ConnectedStreamChannel>(){

                    @Override
                    public void handleException(ConnectedStreamChannel channel, IOException exception) {
                        callback.onException(exchange, null, exception);
                        channel.suspendWrites();
                    }
                }));
                channel.resumeWrites();
            } else {
                callback.onComplete(exchange, null);
            }
        }
        catch (IOException e) {
            callback.onException(exchange, null, e);
            return;
        }
    }
}

