/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;

public final class HttpHandlers {
    public static void executeHandler(HttpHandler handler, HttpServerExchange exchange) {
        try {
            handler.handleRequest(exchange);
        }
        catch (Throwable t) {
            try {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                exchange.setResponseCode(500);
                exchange.endExchange();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void handlerNotNull(HttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }

    public static void handlerNotNull(BlockingHttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }
}

