/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class PathHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final ConcurrentMap<String, HttpHandler> paths = new CopyOnWriteMap<String, HttpHandler>();
    private volatile int maxPathLength = 0;

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        String path;
        int length = (path = exchange.getRelativePath()).length();
        int pos = length > this.maxPathLength ? this.maxPathLength : length;
        String part = path.substring(0, pos);
        HttpHandler next = (HttpHandler)this.paths.get(part);
        if (next != null) {
            exchange.setRelativePath(path.substring(pos));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            HttpHandlers.executeHandler(next, exchange);
            return;
        }
        while (pos > 1) {
            if (path.charAt(--pos) != '/' || (next = (HttpHandler)this.paths.get(part = path.substring(0, pos))) == null) continue;
            exchange.setRelativePath(path.substring(pos));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            HttpHandlers.executeHandler(next, exchange);
            return;
        }
        HttpHandlers.executeHandler(this.defaultHandler, exchange);
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public PathHandler setDefaultHandler(HttpHandler defaultHandler) {
        HttpHandlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
        return this;
    }

    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        if (path.length() > this.maxPathLength) {
            this.maxPathLength = path.length();
        }
        HttpHandlers.handlerNotNull(handler);
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.paths.put("/" + path, handler);
        } else {
            this.paths.put(path, handler);
        }
        return this;
    }

    public synchronized PathHandler removePath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.paths.remove("/" + path);
        } else {
            this.paths.remove(path);
        }
        int max = 0;
        for (Map.Entry entry : this.paths.entrySet()) {
            if (((String)entry.getKey()).length() <= max) continue;
            max = ((String)entry.getKey()).length();
        }
        this.maxPathLength = max;
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.paths.clear();
        return this;
    }

    public Map<String, HttpHandler> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }
}

