/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.RoleMappingManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements BlockingHttpHandler {
    private final BlockingHttpHandler next;
    private final RoleMappingManager roleMappingManager;

    public ServletSecurityRoleHandler(BlockingHttpHandler next, RoleMappingManager roleMappingManager) {
        this.next = next;
        this.roleMappingManager = roleMappingManager;
    }

    @Override
    public void handleBlockingRequest(HttpServerExchange exchange) throws Exception {
        List<Set<String>> roles = exchange.getAttachmentList(ServletAttachments.REQUIRED_ROLES);
        SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        exchange.putAttachment(ServletAttachments.SERVLET_ROLE_MAPPINGS, this.roleMappingManager);
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            this.next.handleBlockingRequest(exchange);
        } else if (roles.isEmpty()) {
            this.next.handleBlockingRequest(exchange);
        } else {
            for (Set<String> roleSet : roles) {
                boolean found = false;
                for (String role : roleSet) {
                    if (!this.roleMappingManager.isUserInRole(role, sc)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                HttpServletResponse response = (HttpServletResponse)exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
                response.sendError(403);
                return;
            }
            this.next.handleBlockingRequest(exchange);
        }
    }
}

