/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.security.api.RoleMappingManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.SecurityRoleRef;
import io.undertow.servlet.core.ServletUpgradeListener;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.PartImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletInputStreamImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.LocaleUtils;
import io.undertow.util.Methods;
import io.undertow.util.QValueParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.xnio.LocalSocketAddress;

public final class HttpServletRequestImpl
implements HttpServletRequest {
    public static final AttachmentKey<ServletRequest> ATTACHMENT_KEY = AttachmentKey.create(ServletRequest.class);
    public static final AttachmentKey<DispatcherType> DISPATCHER_TYPE_ATTACHMENT_KEY = AttachmentKey.create(DispatcherType.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private final HttpServerExchange exchange;
    private ServletContextImpl servletContext;
    private final List<BoundAsyncListener> asyncListeners = new CopyOnWriteArrayList<BoundAsyncListener>();
    private final HashMap<String, Object> attributes = new HashMap();
    private ServletInputStream servletInputStream;
    private BufferedReader reader;
    private Cookie[] cookies;
    private List<Part> parts = null;
    private volatile AsyncContextImpl asyncContext = null;
    private Map<String, Deque<String>> queryParameters;
    private Charset characterEncoding;
    private boolean readStarted;

    public HttpServletRequestImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
        this.queryParameters = exchange.getQueryParameters();
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getAuthType() {
        SecurityContext securityContext = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        return securityContext != null ? securityContext.getMechanismName() : null;
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Map<String, io.undertow.server.handlers.Cookie> cookies = CookieImpl.getRequestCookies(this.exchange);
            if (cookies.isEmpty()) {
                return null;
            }
            Cookie[] value = new Cookie[cookies.size()];
            int i = 0;
            for (Map.Entry<String, io.undertow.server.handlers.Cookie> entry : cookies.entrySet()) {
                io.undertow.server.handlers.Cookie cookie = entry.getValue();
                Cookie c = new Cookie(cookie.getName(), cookie.getValue());
                if (cookie.getDomain() != null) {
                    c.setDomain(cookie.getDomain());
                }
                c.setHttpOnly(cookie.isHttpOnly());
                if (cookie.getMaxAge() != null) {
                    c.setMaxAge(cookie.getMaxAge());
                }
                if (cookie.getPath() != null) {
                    c.setPath(cookie.getPath());
                }
                c.setSecure(cookie.isSecure());
                c.setVersion(cookie.getVersion());
                value[i++] = c;
            }
            this.cookies = value;
        }
        return this.cookies;
    }

    @Override
    public long getDateHeader(String name) {
        String header = this.exchange.getRequestHeaders().getFirst(new HttpString(name));
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate(header);
        if (date == null) {
            throw UndertowServletMessages.MESSAGES.headerCannotBeConvertedToDate(header);
        }
        return date.getTime();
    }

    @Override
    public String getHeader(String name) {
        return this.getHeader(new HttpString(name));
    }

    public String getHeader(HttpString name) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        if (headers == null) {
            return null;
        }
        return headers.getFirst(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        List<String> headers = this.exchange.getRequestHeaders().get(new HttpString(name));
        if (headers == null) {
            return EmptyEnumeration.instance();
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getRequestHeaders()) {
            headers.add(i.toString());
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    @Override
    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    @Override
    public String getMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    @Override
    public String getPathInfo() {
        ServletPathMatch match = this.exchange.getAttachment(ServletAttachments.SERVLET_PATH_MATCH);
        if (match != null) {
            return match.getRemaining();
        }
        return null;
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    @Override
    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    @Override
    public boolean isUserInRole(String role) {
        RoleMappingManager roleMappings = this.exchange.getAttachment(ServletAttachments.SERVLET_ROLE_MAPPINGS);
        if (roleMappings == null) {
            return false;
        }
        SecurityContext sc = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        ServletPathMatch servlet = this.exchange.getAttachment(ServletAttachments.SERVLET_PATH_MATCH);
        for (SecurityRoleRef ref : servlet.getHandler().getManagedServlet().getServletInfo().getSecurityRoleRefs()) {
            if (!ref.getRole().equals(role)) continue;
            return roleMappings.isUserInRole(ref.getLinkedRole(), sc);
        }
        return roleMappings.isUserInRole(role, sc);
    }

    @Override
    public Principal getUserPrincipal() {
        SecurityContext securityContext = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        Principal result = null;
        Account account = null;
        if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) != null) {
            result = account.getPrincipal();
        }
        return result;
    }

    @Override
    public String getRequestedSessionId() {
        return null;
    }

    @Override
    public String changeSessionId() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        if (session == null) {
            throw UndertowServletMessages.MESSAGES.noSession();
        }
        String oldId = session.getId();
        String newId = session.getSession().changeSessionId(this.exchange, this.servletContext.getSessionCookieConfig());
        this.servletContext.getDeployment().getApplicationListeners().httpSessionIdChanged(session, oldId);
        return newId;
    }

    @Override
    public String getRequestURI() {
        return this.exchange.getRequestPath();
    }

    @Override
    public StringBuffer getRequestURL() {
        return new StringBuffer(this.exchange.getRequestURL());
    }

    @Override
    public String getServletPath() {
        ServletPathMatch match = this.exchange.getAttachment(ServletAttachments.SERVLET_PATH_MATCH);
        if (match != null) {
            return match.getMatched();
        }
        return "";
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.servletContext.getSession(this.exchange, create);
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        return session != null;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        return session != null;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        SecurityContext sc = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        sc.setAuthenticationRequired();
        if (sc.authenticate()) {
            if (sc.isAuthenticated()) {
                return true;
            }
            throw UndertowServletMessages.MESSAGES.authenticationFailed();
        }
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl(response);
        responseImpl.closeStreamAndWriter();
        return false;
    }

    @Override
    public void login(String username, String password) throws ServletException {
        if (username == null || password == null) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
        SecurityContext sc = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        if (sc.isAuthenticated()) {
            throw UndertowServletMessages.MESSAGES.userAlreadyLoggedIn();
        }
        if (!sc.login(username, password)) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
    }

    @Override
    public void logout() throws ServletException {
        SecurityContext sc = this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        sc.logout();
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        return this.parts;
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        for (Part part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException {
        try {
            InstanceFactory<T> factory = this.servletContext.getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(handlerClass);
            InstanceHandle<T> instance = factory.createInstance();
            this.exchange.upgradeChannel(new ServletUpgradeListener<T>(instance));
            return (T)((HttpUpgradeHandler)instance.getInstance());
        }
        catch (InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadParts() throws IOException, ServletException {
        this.readStarted = true;
        if (this.parts == null) {
            ArrayList<Part> parts = new ArrayList<Part>();
            String mimeType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (mimeType != null && mimeType.startsWith("multipart/form-data")) {
                FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
                FormData value = parser.parseBlocking();
                for (String namedPart : value) {
                    for (FormData.FormValue part : value.get(namedPart)) {
                        parts.add(new PartImpl(namedPart, part));
                    }
                }
            } else {
                throw UndertowServletMessages.MESSAGES.notAMultiPartRequest();
            }
            this.parts = parts;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    @Override
    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding.name();
        }
        String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        return Headers.extractTokenFromHeader(contentType, "charset");
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.readStarted) {
            return;
        }
        try {
            this.characterEncoding = Charset.forName(env);
            FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                parser.setCharacterEncoding(env);
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException();
        }
    }

    @Override
    public int getContentLength() {
        String contentLength = this.getHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(contentLength);
    }

    @Override
    public long getContentLengthLong() {
        String contentLength = this.getHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    @Override
    public String getContentType() {
        return this.getHeader(Headers.CONTENT_TYPE);
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            if (this.reader != null) {
                throw UndertowServletMessages.MESSAGES.getReaderAlreadyCalled();
            }
            this.servletInputStream = new ServletInputStreamImpl(this);
        }
        this.readStarted = true;
        return this.servletInputStream;
    }

    @Override
    public String getParameter(String name) {
        Deque<String> params = this.queryParameters.get(name);
        if (params == null) {
            if (this.exchange.getRequestMethod().equals(Methods.POST)) {
                this.readStarted = true;
                FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
                if (parser != null) {
                    try {
                        FormData.FormValue res = parser.parseBlocking().getFirst(name);
                        if (res == null) {
                            return null;
                        }
                        return res.getValue();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        }
        try {
            return URLDecoder.decode(params.getFirst(), this.characterEncoding == null ? "ISO-8859-1" : this.characterEncoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Enumeration<String> getParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>(this.queryParameters.keySet());
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    FormData formData = parser.parseBlocking();
                    Iterator<String> it = formData.iterator();
                    while (it.hasNext()) {
                        parameterNames.add(it.next());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new IteratorEnumeration<String>(parameterNames.iterator());
    }

    @Override
    public String[] getParameterValues(String name) {
        ArrayList<String> ret = new ArrayList<String>();
        Deque<String> params = this.queryParameters.get(name);
        if (params != null) {
            for (String param : params) {
                try {
                    ret.add(URLDecoder.decode(param, this.characterEncoding == null ? "ISO-8859-1" : this.characterEncoding.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    Deque<FormData.FormValue> res = parser.parseBlocking().get(name);
                    if (res == null) {
                        return null;
                    }
                    for (FormData.FormValue value : res) {
                        ret.add(value.getValue());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        for (Map.Entry<String, Deque<String>> entry : this.queryParameters.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toArray(new String[entry.getValue().size()]));
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    FormData formData = parser.parseBlocking();
                    for (String name : formData) {
                        Deque<FormData.FormValue> val = formData.get(name);
                        if (ret.containsKey(name)) {
                            String[] existing = (String[])ret.get(name);
                            String[] array = new String[val.size() + existing.length];
                            System.arraycopy(existing, 0, array, 0, existing.length);
                            int i = existing.length;
                            for (FormData.FormValue v : val) {
                                array[i++] = v.getValue();
                            }
                            ret.put(name, array);
                            continue;
                        }
                        String[] array = new String[val.size()];
                        int i = 0;
                        for (FormData.FormValue v : val) {
                            array[i++] = v.getValue();
                        }
                        ret.put(name, array);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ret;
    }

    @Override
    public String getProtocol() {
        return this.exchange.getProtocol().toString();
    }

    @Override
    public String getScheme() {
        return this.exchange.getRequestScheme();
    }

    @Override
    public String getServerName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    @Override
    public int getServerPort() {
        return this.exchange.getDestinationAddress().getPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            if (this.servletInputStream != null) {
                throw UndertowServletMessages.MESSAGES.getInputStreamAlreadyCalled();
            }
            Charset charSet = DEFAULT_CHARSET;
            if (this.characterEncoding != null) {
                charSet = this.characterEncoding;
            } else {
                String c;
                String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                if (contentType != null && (c = Headers.extractTokenFromHeader(contentType, "charset")) != null) {
                    try {
                        charSet = Charset.forName(c);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new UnsupportedEncodingException();
                    }
                }
            }
            this.reader = new BufferedReader(new InputStreamReader(this.exchange.getInputStream(), charSet));
        }
        this.readStarted = true;
        return this.reader;
    }

    @Override
    public String getRemoteAddr() {
        return this.exchange.getSourceAddress().getAddress().getHostAddress();
    }

    @Override
    public String getRemoteHost() {
        return this.exchange.getSourceAddress().getHostName();
    }

    @Override
    public void setAttribute(String name, Object object) {
        Object existing = this.attributes.put(name, object);
        if (existing != null) {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeReplaced(this, name, existing);
        } else {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeAdded(this, name, object);
        }
    }

    @Override
    public void removeAttribute(String name) {
        Object exiting = this.attributes.remove(name);
        this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeRemoved(this, name, exiting);
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        List<String> acceptLanguage = this.exchange.getRequestHeaders().get(Headers.ACCEPT_LANGUAGE);
        if (acceptLanguage == null || acceptLanguage.isEmpty()) {
            return new IteratorEnumeration<Locale>(Collections.singleton(Locale.getDefault()).iterator());
        }
        ArrayList<Locale> ret = new ArrayList<Locale>();
        List<List<QValueParser.QValueResult>> parsedResults = QValueParser.parse(acceptLanguage);
        for (List<QValueParser.QValueResult> qvalueResult : parsedResults) {
            for (QValueParser.QValueResult res : qvalueResult) {
                if (res.isQValueZero()) continue;
                Locale e = LocaleUtils.getLocaleFromString(res.getValue());
                ret.add(e);
            }
        }
        return new IteratorEnumeration<Locale>(ret.iterator());
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        String realPath;
        if (path.startsWith("/")) {
            realPath = path;
        } else {
            String current = this.exchange.getRelativePath();
            int lastSlash = current.lastIndexOf("/");
            if (lastSlash != -1) {
                current = current.substring(0, lastSlash + 1);
            }
            realPath = CanonicalPathUtils.canonicalize(current + path);
        }
        return new RequestDispatcherImpl(realPath, this.servletContext);
    }

    @Override
    public String getRealPath(String path) {
        return null;
    }

    @Override
    public int getRemotePort() {
        return this.exchange.getSourceAddress().getPort();
    }

    @Override
    public String getLocalName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    @Override
    public String getLocalAddr() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        if (address instanceof LocalSocketAddress) {
            return ((LocalSocketAddress)address).getName();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    @Override
    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncContext != null) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.onAsyncStart();
        this.asyncListeners.clear();
        this.asyncContext = new AsyncContextImpl(this.exchange, this.exchange.getAttachment(ATTACHMENT_KEY), this.exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY));
        return this.asyncContext;
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncContext != null) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.onAsyncStart();
        this.asyncListeners.clear();
        this.asyncContext = new AsyncContextImpl(this.exchange, servletRequest, servletResponse);
        return this.asyncContext;
    }

    @Override
    public boolean isAsyncStarted() {
        return this.asyncContext != null;
    }

    @Override
    public boolean isAsyncSupported() {
        Boolean supported = this.exchange.getAttachment(AsyncContextImpl.ASYNC_SUPPORTED);
        return supported == null || supported != false;
    }

    @Override
    public AsyncContextImpl getAsyncContext() {
        if (this.asyncContext == null) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        return this.asyncContext;
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this.exchange.getAttachment(DISPATCHER_TYPE_ATTACHMENT_KEY);
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Deque<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    public void asyncInitialRequestDone() {
        this.asyncContext.initialRequestDone();
        this.asyncContext = null;
    }

    public static HttpServletRequestImpl getRequestImpl(ServletRequest request) {
        HttpServletRequestImpl requestImpl;
        if (request instanceof HttpServletRequestImpl) {
            requestImpl = (HttpServletRequestImpl)request;
        } else if (request instanceof ServletRequestWrapper) {
            requestImpl = HttpServletRequestImpl.getRequestImpl(((ServletRequestWrapper)request).getRequest());
        } else {
            throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
        }
        return requestImpl;
    }

    public void addAsyncListener(AsyncListener listener) {
        this.asyncListeners.add(new BoundAsyncListener(listener, this, this.exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY)));
    }

    public void addAsyncListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.asyncListeners.add(new BoundAsyncListener(listener, servletRequest, servletResponse));
    }

    public void onAsyncComplete() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onComplete(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncTimeout() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onTimeout(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncStart() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onStartAsync(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncError(Throwable t) {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this.asyncContext, listener.servletRequest, listener.servletResponse, t);
            try {
                listener.asyncListener.onStartAsync(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private final class BoundAsyncListener {
        final AsyncListener asyncListener;
        final ServletRequest servletRequest;
        final ServletResponse servletResponse;

        private BoundAsyncListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.asyncListener = asyncListener;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }
    }
}

