/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final String path;
    private final ServletContextImpl servletContext;
    private final ServletInitialHandler handler;
    private final ServletPathMatch pathMatch;
    private final boolean named;

    public RequestDispatcherImpl(String path, ServletContextImpl servletContext) {
        this.path = path;
        this.servletContext = servletContext;
        this.pathMatch = servletContext.getDeployment().getServletPaths().getServletHandlerByPath(path);
        this.handler = this.pathMatch.getHandler();
        this.named = false;
    }

    public RequestDispatcherImpl(ServletInitialHandler handler, ServletContextImpl servletContext) {
        this.handler = handler;
        this.named = true;
        this.servletContext = servletContext;
        this.path = null;
        this.pathMatch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequestImpl requestImpl = HttpServletRequestImpl.getRequestImpl(request);
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl(response);
        HttpServerExchange exchange = requestImpl.getExchange();
        response.resetBuffer();
        ServletRequest oldRequest = exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
        ServletResponse oldResponse = exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.FORWARD);
        Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
        if (!this.named) {
            if (request.getAttribute("javax.servlet.forward.request_uri") == null) {
                request.setAttribute("javax.servlet.forward.request_uri", requestImpl.getRequestURI());
                request.setAttribute("javax.servlet.forward.context_path", requestImpl.getContextPath());
                request.setAttribute("javax.servlet.forward.servlet_path", requestImpl.getServletPath());
                request.setAttribute("javax.servlet.forward.path_info", requestImpl.getPathInfo());
                request.setAttribute("javax.servlet.forward.query_string", requestImpl.getQueryString());
            }
            String newQueryString = "";
            int qsPos = this.path.indexOf("?");
            String newServletPath = this.path;
            if (qsPos != -1) {
                newQueryString = newServletPath.substring(qsPos + 1);
                newServletPath = newServletPath.substring(0, qsPos);
            }
            String newRequestUri = this.servletContext.getContextPath() + newServletPath;
            Map<String, Deque<String>> newQueryParameters = this.createNewQueryParameters(queryParameters, newQueryString);
            requestImpl.setQueryParameters(newQueryParameters);
            requestImpl.getExchange().setRelativePath(newServletPath);
            requestImpl.getExchange().setQueryString(newQueryString);
            requestImpl.getExchange().setRequestPath(newRequestUri);
            requestImpl.getExchange().setRequestURI(newRequestUri);
            requestImpl.getExchange().putAttachment(ServletAttachments.SERVLET_PATH_MATCH, this.pathMatch);
            requestImpl.setServletContext(this.servletContext);
            responseImpl.setServletContext(this.servletContext);
        }
        try {
            try {
                exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, request);
                exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, response);
                this.handler.handleBlockingRequest(exchange);
                if (response instanceof HttpServletResponseImpl) {
                    responseImpl.closeStreamAndWriter();
                } else {
                    try {
                        PrintWriter writer = response.getWriter();
                        writer.flush();
                        writer.close();
                    }
                    catch (IllegalStateException e) {
                        ServletOutputStream outputStream = response.getOutputStream();
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, oldRequest);
            exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, oldResponse);
        }
    }

    private Map<String, Deque<String>> createNewQueryParameters(Map<String, Deque<String>> queryParameters, String newQueryString) {
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            if (!newQueryParameters.containsKey(entry.getKey())) {
                newQueryParameters.put(entry.getKey(), new ArrayDeque(entry.getValue()));
                continue;
            }
            ((Deque)newQueryParameters.get(entry.getKey())).addAll((Collection)entry.getValue());
        }
        return newQueryParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequestImpl requestImpl = HttpServletRequestImpl.getRequestImpl(request);
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl(response);
        HttpServerExchange exchange = requestImpl.getExchange();
        ServletRequest oldRequest = exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
        ServletResponse oldResponse = exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.INCLUDE);
        Object requestUri = null;
        Object contextPath = null;
        Object servletPath = null;
        Object pathInfo = null;
        Object queryString = null;
        Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
        if (!this.named) {
            requestUri = request.getAttribute("javax.servlet.include.request_uri");
            contextPath = request.getAttribute("javax.servlet.include.context_path");
            servletPath = request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = request.getAttribute("javax.servlet.include.path_info");
            queryString = request.getAttribute("javax.servlet.include.query_string");
            String newQueryString = "";
            int qsPos = this.path.indexOf("?");
            String newServletPath = this.path;
            if (qsPos != -1) {
                newQueryString = newServletPath.substring(qsPos + 1);
                newServletPath = newServletPath.substring(0, qsPos);
            }
            String newRequestUri = this.servletContext.getContextPath() + newServletPath;
            Map<String, Deque<String>> newQueryParameters = this.createNewQueryParameters(queryParameters, newQueryString);
            requestImpl.setQueryParameters(newQueryParameters);
            request.setAttribute("javax.servlet.include.request_uri", newRequestUri);
            request.setAttribute("javax.servlet.include.context_path", this.servletContext.getContextPath());
            request.setAttribute("javax.servlet.include.servlet_path", this.pathMatch.getMatched());
            request.setAttribute("javax.servlet.include.path_info", this.pathMatch.getRemaining());
            request.setAttribute("javax.servlet.include.query_string", newQueryString);
        }
        boolean inInclude = responseImpl.isInsideInclude();
        responseImpl.setInsideInclude(true);
        ServletContextImpl oldContext = requestImpl.getServletContext();
        try {
            requestImpl.setServletContext(this.servletContext);
            responseImpl.setServletContext(this.servletContext);
            try {
                exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, request);
                exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, response);
                this.handler.handleBlockingRequest(exchange);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            responseImpl.setInsideInclude(inInclude);
            requestImpl.setServletContext(oldContext);
            responseImpl.setServletContext(oldContext);
            exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, oldRequest);
            exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, oldResponse);
            if (!this.named) {
                request.setAttribute("javax.servlet.include.request_uri", requestUri);
                request.setAttribute("javax.servlet.include.context_path", contextPath);
                request.setAttribute("javax.servlet.include.servlet_path", servletPath);
                request.setAttribute("javax.servlet.include.path_info", pathInfo);
                request.setAttribute("javax.servlet.include.query_string", queryString);
                requestImpl.setQueryParameters(queryParameters);
            }
        }
    }

    public void error(ServletRequest request, ServletResponse response, String servletName, String message) throws ServletException, IOException {
        this.error(request, response, servletName, null, message);
    }

    public void error(ServletRequest request, ServletResponse response, String servletName) throws ServletException, IOException {
        this.error(request, response, servletName, null, null);
    }

    public void error(ServletRequest request, ServletResponse response, String servletName, Throwable exception) throws ServletException, IOException {
        this.error(request, response, servletName, exception, exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(ServletRequest request, ServletResponse response, String servletName, Throwable exception, String message) throws ServletException, IOException {
        HttpServletRequestImpl requestImpl = HttpServletRequestImpl.getRequestImpl(request);
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl(response);
        HttpServerExchange exchange = requestImpl.getExchange();
        response.resetBuffer();
        ServletRequest oldRequest = exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
        ServletResponse oldResponse = exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.ERROR);
        request.setAttribute("javax.servlet.error.request_uri", requestImpl.getRequestURI());
        request.setAttribute("javax.servlet.error.servlet_name", servletName);
        if (exception != null) {
            request.setAttribute("javax.servlet.error.exception", exception);
            request.setAttribute("javax.servlet.error.exception_type", exception.getClass());
        }
        request.setAttribute("javax.servlet.error.message", message);
        request.setAttribute("javax.servlet.error.status_code", exchange.getResponseCode());
        String newQueryString = "";
        int qsPos = this.path.indexOf("?");
        String newServletPath = this.path;
        if (qsPos != -1) {
            newQueryString = newServletPath.substring(qsPos + 1);
            newServletPath = newServletPath.substring(0, qsPos);
        }
        String newRequestUri = this.servletContext.getContextPath() + newServletPath;
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        requestImpl.setQueryParameters(newQueryParameters);
        requestImpl.getExchange().setRelativePath(newServletPath);
        requestImpl.getExchange().setQueryString(newQueryString);
        requestImpl.getExchange().setRequestPath(newRequestUri);
        requestImpl.getExchange().setRequestURI(newRequestUri);
        requestImpl.getExchange().putAttachment(ServletAttachments.SERVLET_PATH_MATCH, this.pathMatch);
        requestImpl.setServletContext(this.servletContext);
        responseImpl.setServletContext(this.servletContext);
        try {
            try {
                exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, request);
                exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, response);
                this.handler.handleBlockingRequest(exchange);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, oldRequest);
            exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, oldResponse);
        }
    }
}

