/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.handler;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Methods;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version00.Hybi00Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WebSocketProtocolHandshakeHandler
implements HttpHandler {
    private final Set<Handshake> handshakes;
    private final WebSocketConnectionCallback callback;

    public WebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback) {
        this.callback = callback;
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add(new Hybi13Handshake());
        handshakes.add(new Hybi08Handshake());
        handshakes.add(new Hybi07Handshake());
        handshakes.add(new Hybi00Handshake());
        this.handshakes = handshakes;
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, WebSocketConnectionCallback callback) {
        this.callback = callback;
        this.handshakes = new HashSet<Handshake>(handshakes);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        if (!exchange.getRequestMethod().equals(Methods.GET)) {
            exchange.setResponseCode(403);
            exchange.endExchange();
            return;
        }
        AsyncWebSocketHttpServerExchange facade = new AsyncWebSocketHttpServerExchange(exchange);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches(facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            UndertowLogger.REQUEST_LOGGER.debug("Could not find hand shaker for web socket request");
            exchange.setResponseCode(403);
            exchange.endExchange();
            return;
        }
        handshaker.handshake(facade, this.callback);
    }
}

