/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.websockets;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.websockets.spi.UpgradeCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Pool;

public class ServletWebSocketHttpExchange
implements WebSocketHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ServletWebSocketHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public <T> void putAttachment(AttachmentKey<T> key, T value) {
        HttpServletRequestImpl.getRequestImpl(this.request).getExchange().putAttachment(key, value);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return HttpServletRequestImpl.getRequestImpl(this.request).getExchange().getAttachment(key);
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        HashMap headers = new HashMap();
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = headerNames.nextElement();
            Enumeration<String> theHeaders = this.request.getHeaders(header);
            ArrayList<String> vals = new ArrayList<String>();
            headers.put(header, vals);
            while (theHeaders.hasMoreElements()) {
                vals.add(theHeaders.nextElement());
            }
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.response.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        Collection<String> headerNames = this.response.getHeaderNames();
        for (String header : headerNames) {
            headers.put(header, new ArrayList<String>(this.response.getHeaders(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        for (String string : this.response.getHeaderNames()) {
            this.response.setHeader(string, null);
        }
        for (Map.Entry entry : headers.entrySet()) {
            for (String val : (List)entry.getValue()) {
                this.response.addHeader((String)entry.getKey(), val);
            }
        }
    }

    @Override
    public void setResponseHeader(String headerName, String headerValue) {
        this.response.setHeader(headerName, headerValue);
    }

    @Override
    public void setResponesCode(int code) {
        this.response.setStatus(code);
    }

    @Override
    public void upgradeChannel(final UpgradeCallback upgradeCallback) {
        HttpServletRequestImpl impl = HttpServletRequestImpl.getRequestImpl(this.request);
        HttpServerExchange exchange = impl.getExchange();
        exchange.upgradeChannel(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                upgradeCallback.handleUpgrade(exchange.getConnection().getChannel(), exchange.getConnection().getBufferPool());
            }
        });
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data) {
        try {
            ServletOutputStream outputStream = this.response.getOutputStream();
            while (data.hasRemaining()) {
                outputStream.write(data.get());
            }
            return new FinishedIoFuture<Object>(null);
        }
        catch (IOException e) {
            ConcreteIoFuture<Void> ioFuture = new ConcreteIoFuture<Void>();
            ioFuture.setException(e);
            return ioFuture;
        }
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int r;
            ServletInputStream in = this.request.getInputStream();
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                data.write(buf, 0, r);
            }
            return new FinishedIoFuture<byte[]>(data.toByteArray());
        }
        catch (IOException e) {
            ConcreteIoFuture<byte[]> ioFuture = new ConcreteIoFuture<byte[]>();
            ioFuture.setException(e);
            return ioFuture;
        }
    }

    @Override
    public void endExchange() {
    }

    @Override
    public void close() {
        HttpServletRequestImpl impl = HttpServletRequestImpl.getRequestImpl(this.request);
        HttpServerExchange exchange = impl.getExchange();
        IoUtils.safeClose((Closeable)exchange.getConnection());
    }

    @Override
    public String getRequestScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        HttpServletRequestImpl impl = HttpServletRequestImpl.getRequestImpl(this.request);
        HttpServerExchange exchange = impl.getExchange();
        return exchange.getConnection().getBufferPool();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public Object getSession() {
        return this.request.getSession(false);
    }
}

