/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.AndPredicate;
import io.undertow.predicate.FalsePredicate;
import io.undertow.predicate.HasRequestHeaderPredicate;
import io.undertow.predicate.MaxContentSizePredicate;
import io.undertow.predicate.MinContentSizePredicate;
import io.undertow.predicate.NotPredicate;
import io.undertow.predicate.OrPredicate;
import io.undertow.predicate.PathMatchPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PrefixMatchPredicate;
import io.undertow.predicate.SuffixMatchPredicate;
import io.undertow.predicate.TruePredicate;

public class Predicates {
    public static Predicate and(Predicate ... predicates) {
        return new AndPredicate(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return new OrPredicate(predicates);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate path(String path) {
        return new PathMatchPredicate(path);
    }

    public static Predicate paths(String ... paths) {
        Predicate[] predicates = new PathMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PathMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate suffix(String path) {
        return new SuffixMatchPredicate(path);
    }

    public static Predicate suffixs(String ... paths) {
        Predicate[] predicates = new SuffixMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new SuffixMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate prefix(String path) {
        return new PrefixMatchPredicate(path);
    }

    public static Predicate prefixs(String ... paths) {
        Predicate[] predicates = new PrefixMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PrefixMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate maxContentSize(long size) {
        return new MaxContentSizePredicate(size);
    }

    public static Predicate minContentSize(long size) {
        return new MinContentSizePredicate(size);
    }

    public static Predicate truePredicate() {
        return TruePredicate.instance();
    }

    public static Predicate falsePredicate() {
        return FalsePredicate.instance();
    }

    public static Predicate hasRequestHeaders(String ... headers) {
        return new HasRequestHeaderPredicate(headers, true);
    }

    public static Predicate hasRequestHeaders(boolean allHeaders, String ... headers) {
        return new HasRequestHeaderPredicate(headers, true);
    }

    private Predicates() {
    }
}

