/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.xnio.IoUtils;

public class BlockingWriterSenderImpl
implements Sender {
    public static final int BUFFER_SIZE = 128;
    private final CharsetDecoder charsetDecoder;
    private final HttpServerExchange exchange;
    private final PrintWriter writer;
    private boolean inCall;
    private String next;
    private IoCallback queuedCallback;

    public BlockingWriterSenderImpl(HttpServerExchange exchange, PrintWriter writer, String charset) {
        this.exchange = exchange;
        this.writer = writer;
        this.charsetDecoder = Charset.forName(charset).newDecoder();
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (this.inCall) {
            this.queue(new ByteBuffer[]{buffer}, callback);
            return;
        }
        if (this.writeBuffer(buffer, callback)) {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        if (this.inCall) {
            this.queue(buffer, callback);
            return;
        }
        for (ByteBuffer b : buffer) {
            if (this.writeBuffer(b, callback)) continue;
            return;
        }
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(String data, IoCallback callback) {
        if (this.inCall) {
            this.queue(data, callback);
            return;
        }
        this.writer.write(data);
        if (this.writer.checkError()) {
            callback.onException(this.exchange, this, new IOException());
        } else {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        if (this.inCall) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(data.getBytes(charset))}, callback);
            return;
        }
        this.writer.write(data);
        if (this.writer.checkError()) {
            callback.onException(this.exchange, this, new IOException());
        } else {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(String data) {
        this.send(data, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset) {
        this.send(data, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void close(IoCallback callback) {
        this.writer.close();
        this.invokeOnComplete(callback);
    }

    @Override
    public void close() {
        IoUtils.safeClose((Closeable)this.writer);
    }

    private boolean writeBuffer(ByteBuffer buffer, IoCallback callback) {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(this.charsetDecoder.decode(buffer));
        }
        catch (CharacterCodingException e) {
            callback.onException(this.exchange, this, e);
            return false;
        }
        String data = builder.toString();
        this.writer.write(data);
        if (this.writer.checkError()) {
            callback.onException(this.exchange, this, new IOException());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete(IoCallback callback) {
        this.inCall = true;
        try {
            callback.onComplete(this.exchange, this);
        }
        finally {
            this.inCall = false;
        }
        while (this.next != null) {
            String next = this.next;
            IoCallback queuedCallback = this.queuedCallback;
            this.next = null;
            this.queuedCallback = null;
            this.writer.write(next);
            if (this.writer.checkError()) {
                queuedCallback.onException(this.exchange, this, new IOException());
                continue;
            }
            this.inCall = true;
            try {
                queuedCallback.onComplete(this.exchange, this);
            }
            finally {
                this.inCall = false;
            }
        }
    }

    private void queue(ByteBuffer[] byteBuffers, IoCallback ioCallback) {
        if (this.next != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer buffer : byteBuffers) {
            try {
                builder.append(this.charsetDecoder.decode(buffer));
            }
            catch (CharacterCodingException e) {
                ioCallback.onException(this.exchange, this, e);
                return;
            }
        }
        this.next = builder.toString();
        this.queuedCallback = ioCallback;
    }

    private void queue(String data, IoCallback callback) {
        if (this.next != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.next = data;
        this.queuedCallback = callback;
    }
}

