/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.Version;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.spec.FilterRegistrationImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletRegistrationImpl;
import io.undertow.servlet.spec.SessionCookieConfigImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class ServletContextImpl
implements ServletContext {
    private final ServletContainer servletContainer;
    private final Deployment deployment;
    private final DeploymentInfo deploymentInfo;
    private final ConcurrentMap<String, Object> attributes;
    private final SessionCookieConfigImpl sessionCookieConfig;
    private final AttachmentKey<HttpSessionImpl> sessionAttachmentKey = AttachmentKey.create(HttpSessionImpl.class);

    public ServletContextImpl(ServletContainer servletContainer, Deployment deployment) {
        this.servletContainer = servletContainer;
        this.deployment = deployment;
        this.deploymentInfo = deployment.getDeploymentInfo();
        this.sessionCookieConfig = new SessionCookieConfigImpl();
        SessionCookieConfig sc = this.deploymentInfo.getSessionCookieConfig();
        if (sc != null) {
            this.sessionCookieConfig.setName(sc.getName());
            this.sessionCookieConfig.setComment(sc.getComment());
            this.sessionCookieConfig.setDomain(sc.getDomain());
            this.sessionCookieConfig.setHttpOnly(sc.isHttpOnly());
            this.sessionCookieConfig.setMaxAge(sc.getMaxAge());
            this.sessionCookieConfig.setPath(sc.getPath());
            this.sessionCookieConfig.setSecure(sc.isSecure());
        }
        this.attributes = this.deploymentInfo.getServletContextAttributeBackingMap() == null ? new ConcurrentHashMap<String, Object>() : this.deploymentInfo.getServletContextAttributeBackingMap();
        this.attributes.putAll(deployment.getDeploymentInfo().getServletContextAttributes());
    }

    @Override
    public String getContextPath() {
        return this.deploymentInfo.getContextPath();
    }

    @Override
    public ServletContext getContext(String uripath) {
        DeploymentManager deploymentByPath = this.servletContainer.getDeploymentByPath(uripath);
        if (deploymentByPath == null) {
            return null;
        }
        return deploymentByPath.getDeployment().getServletContext();
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.deploymentInfo.getMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.deploymentInfo.getMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        int pos = file.lastIndexOf(46);
        if (pos == -1) {
            return this.deployment.getMimeExtensionMappings().get(file);
        }
        return this.deployment.getMimeExtensionMappings().get(file.substring(pos + 1));
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        Resource resource;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null || !resource.isDirectory()) {
            return null;
        }
        HashSet<String> resources = new HashSet<String>();
        for (Resource res : resource.list()) {
            Path file = res.getFile();
            if (file == null) continue;
            resources.add(file.toString());
        }
        return resources;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw UndertowServletMessages.MESSAGES.pathMustStartWithSlash(path);
        }
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        return resource.getUrl();
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        try {
            if (resource.getFile() != null) {
                return new BufferedInputStream(new FileInputStream(resource.getFile().toFile()));
            }
            return new BufferedInputStream(resource.getUrl().openStream());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcherImpl(path, this);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        ServletChain chain = this.deployment.getServletPaths().getServletHandlerByName(name);
        if (chain != null) {
            return new RequestDispatcherImpl(chain, this);
        }
        return null;
    }

    @Override
    public Servlet getServlet(String name) throws ServletException {
        return this.deployment.getServletPaths().getServletHandlerByName(name).getManagedServlet().getServlet().getInstance();
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        return EmptyEnumeration.instance();
    }

    @Override
    public Enumeration<String> getServletNames() {
        return EmptyEnumeration.instance();
    }

    @Override
    public void log(String msg) {
        UndertowServletLogger.ROOT_LOGGER.info(msg);
    }

    @Override
    public void log(Exception exception, String msg) {
        UndertowServletLogger.ROOT_LOGGER.error(msg, exception);
    }

    @Override
    public void log(String message, Throwable throwable) {
        UndertowServletLogger.ROOT_LOGGER.error(message, throwable);
    }

    @Override
    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        Path file = resource.getFile();
        if (file == null) {
            return null;
        }
        return file.toAbsolutePath().toString();
    }

    @Override
    public String getServerInfo() {
        return Version.getFullVersionString();
    }

    @Override
    public String getInitParameter(String name) {
        return this.deploymentInfo.getInitParameters().get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.deploymentInfo.getInitParameters().keySet().iterator());
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.deploymentInfo.getInitParameters().containsKey(name)) {
            return false;
        }
        this.deploymentInfo.addInitParameter(name, value);
        return true;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    @Override
    public void setAttribute(String name, Object object) {
        if (object == null) {
            Object existing = this.attributes.remove(name);
            if (existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, existing);
            }
        } else {
            Object existing = this.attributes.put(name, object);
            if (existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeReplaced(name, existing);
            } else {
                this.deployment.getApplicationListeners().servletContextAttributeAdded(name, object);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        Object exiting = this.attributes.remove(name);
        this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, exiting);
    }

    @Override
    public String getServletContextName() {
        return this.deploymentInfo.getDisplayName();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            ServletInfo servlet = new ServletInfo(servletName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.deploymentInfo.addServlet(servlet);
            this.deployment.getServlets().addServlet(servlet);
            return new ServletRegistrationImpl(servlet, this.deployment);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        ServletInfo s = new ServletInfo(servletName, servlet.getClass(), new ImmediateInstanceFactory<Servlet>(servlet));
        this.deploymentInfo.addServlet(s);
        this.deployment.getServlets().addServlet(s);
        return new ServletRegistrationImpl(s, this.deployment);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        ServletInfo servlet = new ServletInfo(servletName, servletClass);
        this.deploymentInfo.addServlet(servlet);
        this.deployment.getServlets().addServlet(servlet);
        return new ServletRegistrationImpl(servlet, this.deployment);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        ServletInfo servlet = this.deploymentInfo.getServlets().get(servletName);
        if (servlet == null) {
            return null;
        }
        return new ServletRegistrationImpl(servlet, this.deployment);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        HashMap<String, ServletRegistrationImpl> ret = new HashMap<String, ServletRegistrationImpl>();
        for (Map.Entry<String, ServletInfo> entry : this.deploymentInfo.getServlets().entrySet()) {
            ret.put(entry.getKey(), new ServletRegistrationImpl(entry.getValue(), this.deployment));
        }
        return ret;
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        try {
            FilterInfo filter = new FilterInfo(filterName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.deploymentInfo.addFilter(filter);
            this.deployment.getFilters().addFilter(filter);
            return new FilterRegistrationImpl(filter, this.deployment);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        FilterInfo f = new FilterInfo(filterName, filter.getClass(), new ImmediateInstanceFactory<Filter>(filter));
        this.deploymentInfo.addFilter(f);
        this.deployment.getFilters().addFilter(f);
        return new FilterRegistrationImpl(f, this.deployment);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        FilterInfo filter = new FilterInfo(filterName, filterClass);
        this.deploymentInfo.addFilter(filter);
        this.deployment.getFilters().addFilter(filter);
        return new FilterRegistrationImpl(filter, this.deployment);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        FilterInfo filterInfo = this.deploymentInfo.getFilters().get(filterName);
        if (filterInfo == null) {
            return null;
        }
        return new FilterRegistrationImpl(filterInfo, this.deployment);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        HashMap<String, FilterRegistrationImpl> ret = new HashMap<String, FilterRegistrationImpl>();
        for (Map.Entry<String, FilterInfo> entry : this.deploymentInfo.getFilters().entrySet()) {
            ret.put(entry.getKey(), new FilterRegistrationImpl(entry.getValue(), this.deployment));
        }
        return ret;
    }

    @Override
    public SessionCookieConfigImpl getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    @Override
    public void addListener(String className) {
        try {
            Class<?> clazz = this.deploymentInfo.getClassLoader().loadClass(className);
            this.addListener(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        ListenerInfo listener = new ListenerInfo(t.getClass(), new ImmediateInstanceFactory<T>(t));
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener));
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        InstanceFactory<? extends EventListener> factory = null;
        try {
            factory = this.deploymentInfo.getClassIntrospecter().createInstanceFactory(listenerClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        ListenerInfo listener = new ListenerInfo(listenerClass, factory);
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener));
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (InstantiationException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.deploymentInfo.getJspConfigDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.deploymentInfo.getClassLoader();
    }

    @Override
    public void declareRoles(String ... roleNames) {
    }

    public HttpSessionImpl getSession(HttpServerExchange exchange, boolean create) {
        SessionCookieConfigImpl c = this.getSessionCookieConfig();
        HttpSessionImpl httpSession = exchange.getAttachment(this.sessionAttachmentKey);
        if (httpSession != null && httpSession.isInvalid()) {
            exchange.removeAttachment(this.sessionAttachmentKey);
            httpSession = null;
        }
        if (httpSession == null) {
            SessionManager sessionManager = this.deployment.getSessionManager();
            Session session = sessionManager.getSession(exchange, c);
            if (session != null) {
                httpSession = HttpSessionImpl.forSession(session, this, false);
                exchange.putAttachment(this.sessionAttachmentKey, httpSession);
            } else if (create) {
                Session newSession = sessionManager.createSession(exchange, c);
                httpSession = HttpSessionImpl.forSession(newSession, this, true);
                exchange.putAttachment(this.sessionAttachmentKey, httpSession);
            }
        }
        return httpSession;
    }

    public void updateSessionAccessTime(HttpServerExchange exchange) {
        HttpSessionImpl httpSession = this.getSession(exchange, false);
        if (httpSession != null) {
            httpSession.getSession().requestDone(exchange);
        }
    }

    public Deployment getDeployment() {
        return this.deployment;
    }
}

