/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class UpgradeServletOutputStream
extends ServletOutputStream {
    private final StreamSinkChannel channel;
    private WriteListener listener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_DELEGATE_SHUTDOWN = 4;
    private int state;
    private ByteBuffer buffer;

    protected UpgradeServletOutputStream(StreamSinkChannel channel) {
        this.channel = channel;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener == null) {
            Channels.writeBlocking(this.channel, ByteBuffer.wrap(b, off, len));
        } else {
            if (Bits.anyAreClear(this.state, 1)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            ByteBuffer buffer = ByteBuffer.wrap(b);
            do {
                int res;
                if ((res = this.channel.write(buffer)) != 0) continue;
                ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
                copy.put(buffer);
                copy.flip();
                this.buffer = copy;
                this.state &= 0xFFFFFFFE;
                this.channel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener == null) {
            Channels.flushBlocking(this.channel);
        }
    }

    @Override
    public void close() throws IOException {
        this.state |= 2;
        this.state &= 0xFFFFFFFE;
        if (this.listener == null) {
            this.channel.shutdownWrites();
            this.state |= 4;
            Channels.flushBlocking(this.channel);
        } else if (this.buffer == null) {
            this.channel.shutdownWrites();
            this.state |= 4;
            if (!this.channel.flush()) {
                this.channel.resumeWrites();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeBlocking() throws IOException {
        this.state |= 2;
        try {
            if (this.buffer != null) {
                Channels.writeBlocking(this.channel, this.buffer);
            }
            this.channel.shutdownWrites();
            Channels.flushBlocking(this.channel);
        }
        finally {
            this.channel.close();
        }
    }

    @Override
    public boolean isReady() {
        if (this.listener == null) {
            throw UndertowServletMessages.MESSAGES.streamNotInAsyncMode();
        }
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("writeListener");
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        this.listener = writeListener;
        this.channel.getWriteSetter().set(new WriteChannelListener());
        this.channel.resumeWrites();
    }

    private class WriteChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private WriteChannelListener() {
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            if (Bits.anyAreSet(UpgradeServletOutputStream.this.state, 4)) {
                try {
                    channel.flush();
                    return;
                }
                catch (IOException e) {
                    this.handleError(channel, e);
                }
            }
            if (UpgradeServletOutputStream.this.buffer != null) {
                do {
                    try {
                        int res = channel.write(UpgradeServletOutputStream.this.buffer);
                        if (res == 0) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        this.handleError(channel, e);
                    }
                } while (UpgradeServletOutputStream.this.buffer.hasRemaining());
                UpgradeServletOutputStream.this.buffer = null;
            }
            if (Bits.anyAreSet(UpgradeServletOutputStream.this.state, 2)) {
                try {
                    channel.shutdownWrites();
                    UpgradeServletOutputStream.this.state |= 4;
                    channel.flush();
                }
                catch (IOException e) {
                    this.handleError(channel, e);
                }
            } else {
                UpgradeServletOutputStream.this.state |= 1;
                channel.suspendWrites();
                channel.getWorker().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UpgradeServletOutputStream.this.listener.onWritePossible();
                        }
                        catch (IOException e) {
                            UpgradeServletOutputStream.this.listener.onError(e);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleError(StreamSinkChannel channel, IOException e) {
            try {
                UpgradeServletOutputStream.this.listener.onError(e);
            }
            finally {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }
}

