/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.ajp.AjpReadListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.OpenListener;
import java.nio.ByteBuffer;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public class AjpOpenListener
implements OpenListener {
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile String scheme = "http";
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;

    public AjpOpenListener(Pool<ByteBuffer> pool, int bufferSize) {
        this(pool, OptionMap.EMPTY, bufferSize);
    }

    public AjpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, int bufferSize) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        this.bufferSize = bufferSize;
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        HttpServerConnection connection = new HttpServerConnection(channel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize);
        AjpReadListener readListener = new AjpReadListener(connection, this.scheme);
        readListener.startRequest();
        channel.getSourceChannel().setReadListener(readListener);
        readListener.handleEvent(channel.getSourceChannel());
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }
}

