/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ServletInitialHandler
implements HttpHandler,
ServletDispatcher {
    private final HttpHandler next;
    private final CompositeThreadSetupAction setupAction;
    private final ServletContextImpl servletContext;
    private final ApplicationListeners listeners;
    private final ServletPathMatches paths;

    public ServletInitialHandler(ServletPathMatches paths, HttpHandler next, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext) {
        this.next = next;
        this.setupAction = setupAction;
        this.servletContext = servletContext;
        this.paths = paths;
        this.listeners = servletContext.getDeployment().getApplicationListeners();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        final ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, this.servletContext);
        HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, this.servletContext);
        final ServletRequestContext servletRequestContext = new ServletRequestContext(this.servletContext.getDeployment(), request, response, info);
        if (info.getManagedServlet().getMaxRequestSize() > 0L) {
            exchange.setMaxEntitySize(info.getManagedServlet().getMaxRequestSize());
        }
        exchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, servletRequestContext);
        exchange.startBlocking(new ServletBlockingHttpExchange(exchange));
        servletRequestContext.setServletPathMatch(info);
        Executor executor = info.getExecutor();
        if (executor == null) {
            executor = this.servletContext.getDeployment().getExecutor();
        }
        if (exchange.isInIoThread() || executor != null) {
            exchange.dispatch(executor, new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    ServletInitialHandler.this.dispatchRequest(exchange, servletRequestContext, info, DispatcherType.REQUEST);
                }
            });
        } else {
            this.dispatchRequest(exchange, servletRequestContext, info, DispatcherType.REQUEST);
        }
    }

    @Override
    public void dispatchToPath(HttpServerExchange exchange, ServletPathMatch pathInfo, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletPathMatch(pathInfo);
        this.dispatchRequest(exchange, servletRequestContext, pathInfo, dispatcherType);
    }

    @Override
    public void dispatchToServlet(HttpServerExchange exchange, ServletChain servletchain, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        this.dispatchRequest(exchange, servletRequestContext, servletchain, dispatcherType);
    }

    private void dispatchRequest(HttpServerExchange exchange, ServletRequestContext servletRequestContext, ServletChain servletChain, DispatcherType dispatcherType) throws Exception {
        servletRequestContext.setDispatcherType(dispatcherType);
        servletRequestContext.setCurrentServlet(servletChain);
        if (dispatcherType == DispatcherType.REQUEST || dispatcherType == DispatcherType.ASYNC) {
            this.handleFirstRequest(exchange, servletChain, servletRequestContext, servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse());
        } else {
            this.next.handleRequest(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFirstRequest(HttpServerExchange exchange, ServletChain servletChain, ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response) throws Exception {
        ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
        try {
            block16: {
                ServletRequestContext.setCurrentRequestContext(servletRequestContext);
                try {
                    this.listeners.requestInitialized(request);
                    this.next.handleRequest(exchange);
                }
                catch (Throwable t) {
                    if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                        exchange.unDispatch();
                        servletRequestContext.getOriginalRequest().getAsyncContextInternal().handleError(t);
                    }
                    if (exchange.isResponseStarted()) break block16;
                    response.reset();
                    exchange.setResponseCode(500);
                    exchange.getResponseHeaders().clear();
                    String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                    if (location != null) {
                        RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                        try {
                            dispatcher.error(request, response, servletChain.getManagedServlet().getServletInfo().getName(), t);
                        }
                        catch (Exception e) {
                            UndertowLogger.REQUEST_LOGGER.errorf((Throwable)e, "Exception while generating error page %s", (Object)location);
                        }
                    }
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Servlet request failed %s", (Object)exchange);
                    if (response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendError(500);
                    }
                    servletRequestContext.getOriginalResponse().sendError(500);
                }
            }
            this.servletContext.getDeployment().getApplicationListeners().requestDestroyed(request);
            if (!exchange.isDispatched()) {
                servletRequestContext.getOriginalResponse().responseDone();
            }
        }
        finally {
            try {
                handle.tearDown();
            }
            finally {
                ServletRequestContext.clearCurrentServletAttachments();
            }
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }
}

