/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpClientCallback;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpClientUtils;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.net.URI;
import org.xnio.IoFuture;
import org.xnio.channels.StreamSinkChannel;

public abstract class HttpClientRequest
extends AbstractAttachable {
    private final HttpClientConnection connection;
    private final HeaderMap requestHeaders = new HeaderMap();

    protected HttpClientRequest(HttpClientConnection connection) {
        this.connection = connection;
    }

    public abstract String getMethod();

    public abstract URI getTarget();

    public abstract String getProtocol();

    public HttpClientConnection getConnection() {
        return this.connection;
    }

    public final HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public IoFuture<HttpClientResponse> writeRequest() {
        this.writeRequestBody(0L);
        return this.getResponse();
    }

    public abstract StreamSinkChannel writeRequestBody(long var1);

    public abstract IoFuture<HttpClientResponse> getResponse();

    public void writeRequest(HttpClientCallback<HttpClientResponse> responseCallback) {
        IoFuture<HttpClientResponse> response = this.writeRequest();
        HttpClientUtils.addCallback(response, responseCallback);
    }

    public StreamSinkChannel writeRequestBody(long contentLength, HttpClientCallback<HttpClientResponse> responseCallback) throws IOException {
        StreamSinkChannel channel = this.writeRequestBody(contentLength);
        IoFuture<HttpClientResponse> response = this.getResponse();
        HttpClientUtils.addCallback(response, responseCallback);
        return channel;
    }
}

