/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import java.util.ArrayList;
import java.util.List;

public class CompositeThreadSetupAction
implements ThreadSetupAction {
    private final List<ThreadSetupAction> actions;

    public CompositeThreadSetupAction(List<ThreadSetupAction> actions) {
        this.actions = actions;
    }

    @Override
    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        final ArrayList<ThreadSetupAction.Handle> handles = new ArrayList<ThreadSetupAction.Handle>(this.actions.size());
        try {
            for (ThreadSetupAction action : this.actions) {
                ThreadSetupAction.Handle result = action.setup(exchange);
                if (result == null) continue;
                handles.add(result);
            }
            return new ThreadSetupAction.Handle(){

                @Override
                public void tearDown() {
                    Throwable problem = null;
                    for (ThreadSetupAction.Handle handle : handles) {
                        try {
                            handle.tearDown();
                        }
                        catch (Throwable e) {
                            problem = e;
                        }
                    }
                    if (problem != null) {
                        throw new RuntimeException(problem);
                    }
                }
            };
        }
        catch (RuntimeException e) {
            for (ThreadSetupAction.Handle handle : handles) {
                try {
                    handle.tearDown();
                }
                catch (Throwable ignore) {}
            }
            throw e;
        }
        catch (Error e) {
            for (ThreadSetupAction.Handle handle : handles) {
                try {
                    handle.tearDown();
                }
                catch (Throwable ignore) {}
            }
            throw e;
        }
    }
}

