/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.SameThreadExecutor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.xnio.XnioExecutor;

public class AsyncContextImpl
implements AsyncContext {
    public static final AttachmentKey<Boolean> ASYNC_SUPPORTED = AttachmentKey.create(Boolean.class);
    public static final AttachmentKey<Executor> ASYNC_EXECUTOR = AttachmentKey.create(Executor.class);
    private final HttpServerExchange exchange;
    private final ServletRequest servletRequest;
    private final ServletResponse servletResponse;
    private final TimeoutTask timeoutTask = new TimeoutTask();
    private volatile long timeout = 120000L;
    private volatile XnioExecutor.Key timeoutKey;
    private boolean dispatched;
    private boolean initialRequestDone;
    private Thread initiatingThread;
    private final Deque<Runnable> asyncTaskQueue = new ArrayDeque<Runnable>();
    private boolean processingAsyncTask = false;

    public AsyncContextImpl(final HttpServerExchange exchange, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.exchange = exchange;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.initiatingThread = Thread.currentThread();
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                exchange.setDispatchExecutor(null);
                AsyncContextImpl.this.initialRequestDone();
            }
        });
    }

    public void updateTimeout() {
        XnioExecutor.Key key = this.timeoutKey;
        if (key != null && !key.remove()) {
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutKey = this.exchange.getIoThread().executeAfter(this.timeoutTask, this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    @Override
    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.servletRequest instanceof HttpServletRequestImpl && this.servletResponse instanceof HttpServletResponseImpl;
    }

    @Override
    public void dispatch() {
        HttpServletRequestImpl requestImpl = HttpServletRequestImpl.getRequestImpl(this.servletRequest);
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        ServletPathMatch handler = this.servletRequest instanceof HttpServletRequest ? deployment.getServletPaths().getServletHandlerByPath(((HttpServletRequest)this.servletRequest).getServletPath()) : deployment.getServletPaths().getServletHandlerByPath(this.exchange.getRelativePath());
        HttpServerExchange exchange = requestImpl.getExchange();
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.ASYNC);
        exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, this.servletRequest);
        exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, this.servletResponse);
        this.dispatchAsyncRequest(deployment.getServletDispatcher(), handler, exchange);
    }

    private void dispatchAsyncRequest(final ServletDispatcher servletDispatcher, final ServletPathMatch pathInfo, final HttpServerExchange exchange) {
        this.doDispatch(new Runnable(){

            @Override
            public void run() {
                HttpHandlers.executeRootHandler(new HttpHandler(){

                    @Override
                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        servletDispatcher.dispatchToPath(exchange, pathInfo, DispatcherType.ASYNC);
                    }
                }, exchange, false);
            }
        });
    }

    @Override
    public void dispatch(String path) {
        this.dispatch(this.servletRequest.getServletContext(), path);
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        HttpServletRequestImpl requestImpl = HttpServletRequestImpl.getRequestImpl(this.servletRequest);
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl(this.servletResponse);
        HttpServerExchange exchange = requestImpl.getExchange();
        exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.ASYNC);
        requestImpl.setAttribute("javax.servlet.async.request_uri", requestImpl.getRequestURI());
        requestImpl.setAttribute("javax.servlet.async.context_path", requestImpl.getContextPath());
        requestImpl.setAttribute("javax.servlet.async.servlet_path", requestImpl.getServletPath());
        requestImpl.setAttribute("javax.servlet.async.query_string", requestImpl.getQueryString());
        String newQueryString = "";
        int qsPos = path.indexOf("?");
        String newServletPath = path;
        if (qsPos != -1) {
            newQueryString = newServletPath.substring(qsPos + 1);
            newServletPath = newServletPath.substring(0, qsPos);
        }
        String newRequestUri = context.getContextPath() + newServletPath;
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        requestImpl.setQueryParameters(newQueryParameters);
        requestImpl.getExchange().setRelativePath(newServletPath);
        requestImpl.getExchange().setQueryString(newQueryString);
        requestImpl.getExchange().setRequestPath(newRequestUri);
        requestImpl.getExchange().setRequestURI(newRequestUri);
        requestImpl.setServletContext((ServletContextImpl)context);
        responseImpl.setServletContext((ServletContextImpl)context);
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        ServletPathMatch info = deployment.getServletPaths().getServletHandlerByPath(newServletPath);
        requestImpl.getExchange().putAttachment(ServletAttachments.SERVLET_PATH_MATCH, info);
        this.dispatchAsyncRequest(deployment.getServletDispatcher(), info, exchange);
    }

    @Override
    public synchronized void complete() {
        HttpServletRequestImpl.getRequestImpl(this.servletRequest).onAsyncComplete();
        this.completeInternal();
    }

    public synchronized void completeInternal() {
        if (!this.initialRequestDone && Thread.currentThread() == this.initiatingThread) {
            if (this.dispatched) {
                throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
            }
            this.dispatched = true;
            HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(this.servletRequest);
            this.initialRequestDone();
            request.asyncRequestDispatched();
        } else {
            this.doDispatch(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpServletResponseImpl response = HttpServletResponseImpl.getResponseImpl(AsyncContextImpl.this.servletResponse);
                    HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(AsyncContextImpl.this.servletRequest);
                    try {
                        request.getServletContext().getDeployment().getApplicationListeners().requestDestroyed(request);
                    }
                    finally {
                        response.responseDone();
                    }
                }
            });
        }
    }

    @Override
    public void start(final Runnable run) {
        Executor executor = this.asyncExecutor();
        final CompositeThreadSetupAction setup = HttpServletRequestImpl.getRequestImpl(this.servletRequest).getServletContext().getDeployment().getThreadSetupAction();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadSetupAction.Handle handle = setup.setup(null);
                try {
                    run.run();
                }
                finally {
                    handle.tearDown();
                }
            }
        });
    }

    private Executor asyncExecutor() {
        Executor executor = this.exchange.getAttachment(ASYNC_EXECUTOR);
        if (executor == null) {
            executor = this.exchange.getDispatchExecutor();
        }
        if (executor == null) {
            executor = this.exchange.getConnection().getWorker();
        }
        return executor;
    }

    @Override
    public void addListener(AsyncListener listener) {
        HttpServletRequestImpl.getRequestImpl(this.servletRequest).addAsyncListener(listener);
    }

    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequestImpl.getRequestImpl(servletRequest).addAsyncListener(listener, servletRequest, servletResponse);
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            InstanceFactory<T> factory = ((ServletContextImpl)this.servletRequest.getServletContext()).getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(clazz);
            return (T)((AsyncListener)factory.createInstance().getInstance());
        }
        catch (NoSuchMethodException e) {
            throw new ServletException(e);
        }
        catch (InstantiationException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public synchronized void initialRequestDone() {
        this.initialRequestDone = true;
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
        this.initiatingThread = null;
    }

    private synchronized void doDispatch(Runnable runnable) {
        if (this.dispatched) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
        }
        this.dispatched = true;
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(this.servletRequest);
        request.asyncRequestDispatched();
        this.addAsyncTask(runnable);
        if (this.timeoutKey != null) {
            this.timeoutKey.remove();
        }
    }

    private synchronized void processAsyncTask() {
        if (!this.initialRequestDone) {
            return;
        }
        this.updateTimeout();
        Runnable task = this.asyncTaskQueue.poll();
        if (task != null) {
            this.processingAsyncTask = true;
            this.asyncExecutor().execute(new TaskDispatchRunnable(task));
        } else {
            this.processingAsyncTask = false;
        }
    }

    public synchronized void addAsyncTask(Runnable runnable) {
        this.asyncTaskQueue.add(runnable);
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
    }

    private class TaskDispatchRunnable
    implements Runnable {
        private final Runnable task;

        private TaskDispatchRunnable(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                AsyncContextImpl.this.processAsyncTask();
            }
        }
    }

    private final class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncContextImpl asyncContextImpl = AsyncContextImpl.this;
            synchronized (asyncContextImpl) {
                if (!AsyncContextImpl.this.dispatched) {
                    UndertowServletLogger.REQUEST_LOGGER.debug("Async request timed out");
                    HttpServletRequestImpl.getRequestImpl(AsyncContextImpl.this.servletRequest).onAsyncTimeout();
                    AsyncContextImpl.this.completeInternal();
                }
            }
        }
    }
}

