/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;

public class BasicAuthenticationMechanism
implements AuthenticationMechanism {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String name;
    private final String challenge;
    private static final String BASIC_PREFIX = Headers.BASIC + " ";
    private static final int PREFIX_LENGTH = BASIC_PREFIX.length();
    private static final String COLON = ":";

    public BasicAuthenticationMechanism(String realmName) {
        this(realmName, "BASIC");
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName) {
        this.challenge = BASIC_PREFIX + "realm=\"" + realmName + "\"";
        this.name = mechanismName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        List<String> authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                int colonPos;
                if (!current.startsWith(BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                String plainChallenge = null;
                try {
                    ByteBuffer decode = FlexBase64.decode(base64Challenge);
                    plainChallenge = new String(decode.array(), decode.arrayOffset(), decode.limit(), UTF_8);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (plainChallenge != null && (colonPos = plainChallenge.indexOf(COLON)) > -1) {
                    String userName = plainChallenge.substring(0, colonPos);
                    char[] password = plainChallenge.substring(colonPos + 1).toCharArray();
                    IdentityManager idm = securityContext.getIdentityManager();
                    PasswordCredential credential = new PasswordCredential(password);
                    try {
                        AuthenticationMechanism.AuthenticationMechanismOutcome result;
                        Account account = idm.verify(userName, credential);
                        if (account != null) {
                            securityContext.authenticationComplete(account, this.getName());
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        } else {
                            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.getName());
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                        }
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = result;
                        return authenticationMechanismOutcome;
                    }
                    finally {
                        BasicAuthenticationMechanism.clear(password);
                    }
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, this.challenge);
        return new AuthenticationMechanism.ChallengeResult(true, 401);
    }

    private static void clear(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }
}

