/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

class SenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final StreamSinkChannel streamSinkChannel;
    private final HttpServerExchange exchange;

    SenderImpl(StreamSinkChannel streamSinkChannel, HttpServerExchange exchange) {
        this.streamSinkChannel = streamSinkChannel;
        this.exchange = exchange;
    }

    @Override
    public void send(final ByteBuffer buffer, final IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = this.streamSinkChannel.write(buffer);
                if (res != 0) continue;
                this.streamSinkChannel.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<Channel>(){

                    @Override
                    public void handleEvent(Channel channel) {
                        try {
                            do {
                                int res;
                                if ((res = SenderImpl.this.streamSinkChannel.write(buffer)) != 0) continue;
                                return;
                            } while (buffer.hasRemaining());
                            SenderImpl.this.streamSinkChannel.suspendWrites();
                            callback.onComplete(SenderImpl.this.exchange, SenderImpl.this);
                        }
                        catch (IOException e) {
                            SenderImpl.this.streamSinkChannel.suspendWrites();
                            callback.onException(SenderImpl.this.exchange, SenderImpl.this, e);
                        }
                    }
                });
                this.streamSinkChannel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            callback.onComplete(this.exchange, this);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(final ByteBuffer[] buffer, final IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        long t = 0L;
        for (ByteBuffer l : buffer) {
            t += (long)l.remaining();
        }
        final long total = t;
        long written = 0L;
        try {
            do {
                long res = this.streamSinkChannel.write(buffer);
                written += res;
                if (res != 0L) continue;
                final long finalWritten = written;
                this.streamSinkChannel.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<Channel>(){
                    long written;
                    {
                        this.written = finalWritten;
                    }

                    @Override
                    public void handleEvent(Channel channel) {
                        try {
                            do {
                                long res = SenderImpl.this.streamSinkChannel.write(buffer);
                                this.written += res;
                                if (res != 0L) continue;
                                return;
                            } while (this.written < total);
                            callback.onComplete(SenderImpl.this.exchange, SenderImpl.this);
                        }
                        catch (IOException e) {
                            callback.onException(SenderImpl.this.exchange, SenderImpl.this, e);
                        }
                    }
                });
                this.streamSinkChannel.resumeWrites();
                return;
            } while (written < total);
            callback.onComplete(this.exchange, this);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(utf8)), callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(charset)), callback);
    }

    @Override
    public void close(final IoCallback callback) {
        block5: {
            try {
                this.streamSinkChannel.shutdownWrites();
                if (!this.streamSinkChannel.flush()) {
                    this.streamSinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            callback.onComplete(SenderImpl.this.exchange, SenderImpl.this);
                        }
                    }, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            callback.onException(SenderImpl.this.exchange, SenderImpl.this, exception);
                        }
                    }));
                    this.streamSinkChannel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block5;
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }
}

