/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.BinaryFrameSender;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.impl.AbstractSender;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.streams.ChannelOutputStream;

class DefaultBinaryFrameSender
extends AbstractSender
implements BinaryFrameSender {
    DefaultBinaryFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected WebSocketFrameType type() {
        return WebSocketFrameType.BINARY;
    }

    @Override
    public void sendBinary(ByteBuffer payload, SendCallback callback) {
        try {
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(payload.remaining()));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendBinary(ByteBuffer[] payload, SendCallback callback) {
        try {
            long length = StreamSinkChannelUtils.payloadLength(payload);
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(length));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendBinary(final FileChannel payloadChannel, final int offset, final long length, final SendCallback callback) {
        try {
            if (length > payloadChannel.size() - (long)offset) {
                throw WebSocketMessages.MESSAGES.lengthBiggerThenFileChannel();
            }
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(length));
            long written = 0L;
            while (written < length) {
                long w = sink.transferFrom(payloadChannel, (long)offset + written, length - written);
                if (w == 0L) {
                    final long writtenBytes = written;
                    sink.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){
                        long written;
                        {
                            this.written = writtenBytes;
                        }

                        @Override
                        public void handleEvent(StreamSinkChannel sink) {
                            try {
                                while (this.written < length) {
                                    long w = sink.transferFrom(payloadChannel, (long)offset + this.written, length - this.written);
                                    if (w == 0L) {
                                        sink.resumeWrites();
                                        return;
                                    }
                                    if (w <= 0L) continue;
                                    this.written += w;
                                }
                                StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
                            }
                            catch (IOException e) {
                                StreamSinkChannelUtils.safeNotify(callback, e);
                            }
                        }
                    });
                    sink.resumeWrites();
                    return;
                }
                if (w <= 0L) continue;
                written += w;
            }
            StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendBinary(ByteBuffer payload) throws IOException {
        this.checkBlockingAllowed();
        StreamSinkChannel sink = this.createSink(payload.remaining());
        StreamSinkChannelUtils.send(sink, payload);
    }

    @Override
    public void sendBinary(ByteBuffer[] payload) throws IOException {
        this.checkBlockingAllowed();
        long length = StreamSinkChannelUtils.payloadLength(payload);
        StreamSinkChannel sink = this.createSink(length);
        StreamSinkChannelUtils.send(sink, payload);
    }

    @Override
    public OutputStream sendBinary(long payloadSize) throws IOException {
        this.checkBlockingAllowed();
        return new ChannelOutputStream(this.createSink(payloadSize));
    }
}

