/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public class ChunkedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    public static final AttachmentKey<HeaderMap> TRAILERS = AttachmentKey.create(HeaderMap.class);
    private final Attachable attachable;
    private final BufferWrapper bufferWrapper;
    private final ConduitListener<? super ChunkedStreamSourceConduit> finishListener;
    private final HttpServerExchange exchange;
    private long state;
    private long remainingAllowed;
    private TrailerParser trailerParser;
    private static final long FLAG_CLOSED = Long.MIN_VALUE;
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_READING_LENGTH = 0x2000000000000000L;
    private static final long FLAG_READING_TILL_END_OF_LINE = 0x1000000000000000L;
    private static final long FLAG_READING_NEWLINE = 0x800000000000000L;
    private static final long FLAG_READING_AFTER_LAST = 0x400000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 56);

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final PushBackStreamSourceConduit channel, final Pool<ByteBuffer> pool, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return pool.allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                channel.pushBack(pooled);
            }
        }, finishListener, attachable, null);
    }

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final HttpServerExchange exchange, ConduitListener<? super ChunkedStreamSourceConduit> finishListener) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return exchange.getConnection().getBufferPool().allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                ((HttpServerConnection)exchange.getConnection()).ungetRequestBytes(pooled);
            }
        }, finishListener, exchange, exchange);
    }

    protected ChunkedStreamSourceConduit(StreamSourceConduit next, BufferWrapper bufferWrapper, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable, HttpServerExchange exchange) {
        super(next);
        this.bufferWrapper = bufferWrapper;
        this.finishListener = finishListener;
        this.remainingAllowed = Long.MIN_VALUE;
        this.attachable = attachable;
        this.exchange = exchange;
        this.state = 0x2000000000000000L;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    private void updateRemainingAllowed(int written) throws IOException {
        if (this.remainingAllowed == Long.MIN_VALUE) {
            if (this.exchange == null) {
                return;
            }
            long maxEntitySize = this.exchange.getMaxEntitySize();
            if (maxEntitySize <= 0L) {
                return;
            }
            this.remainingAllowed = maxEntitySize;
        }
        this.remainingAllowed -= (long)written;
        if (this.remainingAllowed < 0L) {
            try {
                ((StreamSourceConduit)this.next).terminateReads();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception terminating reads due to exceeding max size", e);
            }
            this.state |= 0xC000000000000000L;
            this.finishListener.handleEvent(this);
            this.exchange.setPersistent(false);
            throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(this.exchange.getMaxEntitySize());
        }
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    @Override
    public void terminateReads() throws IOException {
        if (!this.isFinished()) {
            super.terminateReads();
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        long oldVal = this.state;
        if (Bits.anyAreSet(oldVal, 0x4000000000000000L)) {
            return -1;
        }
        if (Bits.anyAreSet(oldVal, Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        long chunkRemaining = oldVal & MASK_COUNT;
        Pooled<ByteBuffer> pooled = this.bufferWrapper.allocate();
        ByteBuffer buf = pooled.getResource();
        int r = ((StreamSourceConduit)this.next).read(buf);
        buf.flip();
        if (r == -1) {
            throw new ClosedChannelException();
        }
        if (r == 0) {
            return 0;
        }
        long newVal = oldVal;
        try {
            int n;
            long chunkInBuffer;
            int read;
            int originalLimit;
            block46: {
                int c;
                byte b;
                if (Bits.anyAreSet(oldVal, 0x400000000000000L)) {
                    int ret = this.handleChunkedRequestEnd(buf);
                    if (ret == -1) {
                        newVal |= 0x4000000000000000L;
                    }
                    int n2 = ret;
                    return n2;
                }
                while (Bits.anyAreSet(newVal, 0x800000000000000L)) {
                    while (buf.hasRemaining()) {
                        b = buf.get();
                        if (b != 10) continue;
                        newVal = newVal & 0xF7FFFFFFFFFFFFFFL | 0x2000000000000000L;
                        break;
                    }
                    if (!Bits.anyAreSet(newVal, 0x800000000000000L)) continue;
                    buf.clear();
                    c = ((StreamSourceConduit)this.next).read(buf);
                    buf.flip();
                    if (c == -1) {
                        throw new ClosedChannelException();
                    }
                    if (c != 0) continue;
                    int n3 = 0;
                    return n3;
                }
                while (Bits.anyAreSet(newVal, 0x2000000000000000L)) {
                    while (buf.hasRemaining()) {
                        b = buf.get();
                        if (b >= 48 && b <= 57 || b >= 97 && b <= 102 || b >= 65 && b <= 70) {
                            chunkRemaining <<= 4;
                            chunkRemaining += (long)Character.digit((char)b, 16);
                            continue;
                        }
                        if (b == 10) {
                            newVal &= 0xDFFFFFFFFFFFFFFFL;
                            break;
                        }
                        newVal = newVal & 0xDFFFFFFFFFFFFFFFL | 0x1000000000000000L;
                        break;
                    }
                    if (!Bits.anyAreSet(newVal, 0x2000000000000000L)) continue;
                    buf.clear();
                    c = ((StreamSourceConduit)this.next).read(buf);
                    buf.flip();
                    if (c == -1) {
                        throw new ClosedChannelException();
                    }
                    if (c != 0) continue;
                    int n4 = 0;
                    return n4;
                }
                while (Bits.anyAreSet(newVal, 0x1000000000000000L)) {
                    while (buf.hasRemaining()) {
                        if (buf.get() != 10) continue;
                        newVal &= 0xEFFFFFFFFFFFFFFFL;
                        break;
                    }
                    if (!Bits.anyAreSet(newVal, 0x1000000000000000L)) continue;
                    buf.clear();
                    c = ((StreamSourceConduit)this.next).read(buf);
                    buf.flip();
                    if (c == -1) {
                        throw new ClosedChannelException();
                    }
                    if (c != 0) continue;
                    int n5 = 0;
                    return n5;
                }
                if (Bits.allAreClear(newVal, 0x3800000000000000L) && chunkRemaining == 0L) {
                    newVal |= 0x400000000000000L;
                    int ret = this.handleChunkedRequestEnd(buf);
                    if (ret == -1) {
                        newVal |= 0x4000000000000000L;
                    }
                    int n6 = ret;
                    return n6;
                }
                originalLimit = dst.limit();
                read = 0;
                chunkInBuffer = Math.min((long)buf.remaining(), chunkRemaining);
                int remaining = dst.remaining();
                if (chunkInBuffer <= (long)remaining) break block46;
                int orig = buf.limit();
                buf.limit(buf.position() + remaining);
                dst.put(buf);
                buf.limit(orig);
                chunkRemaining -= (long)remaining;
                this.updateRemainingAllowed(remaining);
                int n7 = remaining;
                dst.limit(originalLimit);
                return n7;
            }
            try {
                int old;
                if (buf.hasRemaining()) {
                    old = buf.limit();
                    buf.limit((int)Math.min((long)old, (long)buf.position() + chunkInBuffer));
                    try {
                        dst.put(buf);
                    }
                    finally {
                        buf.limit(old);
                    }
                    read = (int)((long)read + chunkInBuffer);
                    chunkRemaining -= chunkInBuffer;
                }
                if (chunkRemaining > 0L) {
                    old = dst.limit();
                    try {
                        if (chunkRemaining < (long)dst.remaining()) {
                            dst.limit((int)((long)dst.position() + chunkRemaining));
                        }
                        int c = 0;
                        do {
                            if ((c = ((StreamSourceConduit)this.next).read(dst)) <= 0) continue;
                            read += c;
                            chunkRemaining -= (long)c;
                        } while (c > 0 && chunkRemaining > 0L);
                        if (c == -1) {
                            newVal |= 0x4000000000000000L;
                        }
                    }
                    finally {
                        dst.limit(old);
                    }
                }
                if (chunkRemaining == 0L) {
                    newVal |= 0x800000000000000L;
                }
                this.updateRemainingAllowed(read);
                n = read;
                dst.limit(originalLimit);
            }
            catch (Throwable throwable) {
                dst.limit(originalLimit);
                throw throwable;
            }
            return n;
        }
        finally {
            this.state = newVal = newVal & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
            if (buf.hasRemaining()) {
                this.bufferWrapper.pushBack(pooled);
            }
            if (Bits.allAreClear(oldVal, 0x4000000000000000L) && Bits.allAreSet(newVal, 0x4000000000000000L)) {
                this.callFinish();
            }
        }
    }

    private int handleChunkedRequestEnd(ByteBuffer buffer) throws IOException {
        if (this.trailerParser != null) {
            return this.trailerParser.handle(buffer);
        }
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 10) {
                return -1;
            }
            if (b == 13) continue;
            buffer.position(buffer.position() - 1);
            this.trailerParser = new TrailerParser();
            return this.trailerParser.handle(buffer);
        }
        return 0;
    }

    public boolean isFinished() {
        return Bits.anyAreSet(this.state, 0x4000000000000000L);
    }

    private void callFinish() {
        this.finishListener.handleEvent(this);
    }

    private final class TrailerParser {
        private HeaderMap headerMap = new HeaderMap();
        private StringBuilder builder = new StringBuilder();
        private HttpString httpString;
        int state = 0;
        private static final int STATE_TRAILER_NAME = 0;
        private static final int STATE_TRAILER_VALUE = 1;
        private static final int STATE_ENDING = 2;

        private TrailerParser() {
        }

        public int handle(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                byte b = buf.get();
                if (this.state == 0) {
                    if (b == 13) {
                        if (this.builder.length() == 0) {
                            this.state = 2;
                            continue;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b == 10) {
                        if (this.builder.length() == 0) {
                            ChunkedStreamSourceConduit.this.attachable.putAttachment(TRAILERS, this.headerMap);
                            return -1;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b == 58) {
                        this.httpString = HttpString.tryFromString(this.builder.toString().trim());
                        this.state = 1;
                        this.builder.setLength(0);
                        continue;
                    }
                    this.builder.append((char)b);
                    continue;
                }
                if (this.state == 1) {
                    if (b == 10) {
                        this.headerMap.put(this.httpString, this.builder.toString().trim());
                        this.httpString = null;
                        this.builder.setLength(0);
                        this.state = 0;
                        continue;
                    }
                    if (b == 13) continue;
                    this.builder.append((char)b);
                    continue;
                }
                if (this.state == 2) {
                    if (b == 10) {
                        if (ChunkedStreamSourceConduit.this.attachable != null) {
                            ChunkedStreamSourceConduit.this.attachable.putAttachment(TRAILERS, this.headerMap);
                        }
                        return -1;
                    }
                    throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                }
                throw new IllegalStateException();
            }
            return 0;
        }
    }

    static interface BufferWrapper {
        public Pooled<ByteBuffer> allocate();

        public void pushBack(Pooled<ByteBuffer> var1);
    }
}

