/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.util.FlexBase64;
import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.version13.WebSocket13Channel;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.http.HandshakeChecker;

public class WebSocket13ClientHandshake
extends WebSocketClientHandshake {
    public static final String MAGIC_NUMBER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocket13ClientHandshake(URI url) {
        super(url);
    }

    @Override
    public WebSocketChannel createChannel(StreamConnection channel, String wsUri, Pool<ByteBuffer> bufferPool) {
        return new WebSocket13Channel(channel, bufferPool, wsUri, Collections.<String>emptySet(), true, false);
    }

    @Override
    public Map<String, String> createHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Upgrade", "websocket");
        headers.put("Connection", "upgrade");
        String key = this.createSecKey();
        headers.put("Sec-WebSocket-Key", key);
        headers.put("Sec-WebSocket-Version", this.getVersion().toHttpHeaderValue());
        return headers;
    }

    protected String createSecKey() {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int val = random.nextInt();
            data[i * 4] = (byte)val;
            data[i * 4 + 1] = (byte)(val >> 8 & 0xFF);
            data[i * 4 + 2] = (byte)(val >> 16 & 0xFF);
            data[i * 4 + 3] = (byte)(val >> 24 & 0xFF);
        }
        return FlexBase64.encodeString(data, false);
    }

    @Override
    public HandshakeChecker handshakeChecker(URI uri, Map<String, String> requestHeaders) {
        final String sentKey = requestHeaders.get("Sec-WebSocket-Key");
        return new HandshakeChecker(){

            @Override
            public void checkHandshake(Map<String, String> headers) throws IOException {
                String upgrade = headers.get("Upgrade".toLowerCase());
                if (upgrade == null || !upgrade.toLowerCase().trim().equals("websocket")) {
                    throw WebSocketMessages.MESSAGES.noWebSocketUpgradeHeader();
                }
                String connHeader = headers.get("Connection".toLowerCase());
                if (connHeader == null || !connHeader.toLowerCase().trim().equals("upgrade")) {
                    throw WebSocketMessages.MESSAGES.noWebSocketConnectionHeader();
                }
                String acceptKey = headers.get("Sec-WebSocket-Accept".toLowerCase());
                String dKey = WebSocket13ClientHandshake.this.solve(sentKey);
                if (!dKey.equals(acceptKey)) {
                    throw WebSocketMessages.MESSAGES.webSocketAcceptKeyMismatch(dKey, acceptKey);
                }
            }
        };
    }

    protected final String solve(String nonceBase64) {
        try {
            String concat = nonceBase64 + MAGIC_NUMBER;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(WebSocketUtils.UTF_8));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString(bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public WebSocketVersion getVersion() {
        return WebSocketVersion.V13;
    }
}

